/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;

public class ServerboundSeenAdvancementsPacket
implements Packet<ServerGamePacketListener> {
    private final Action action;
    @Nullable
    private final ResourceLocation tab;

    public ServerboundSeenAdvancementsPacket(Action pAction, @Nullable ResourceLocation pTab) {
        this.action = pAction;
        this.tab = pTab;
    }

    public static ServerboundSeenAdvancementsPacket openedTab(Advancement pAdvancement) {
        return new ServerboundSeenAdvancementsPacket(Action.OPENED_TAB, pAdvancement.getId());
    }

    public static ServerboundSeenAdvancementsPacket closedScreen() {
        return new ServerboundSeenAdvancementsPacket(Action.CLOSED_SCREEN, null);
    }

    public ServerboundSeenAdvancementsPacket(FriendlyByteBuf pBuffer) {
        this.action = pBuffer.readEnum(Action.class);
        this.tab = this.action == Action.OPENED_TAB ? pBuffer.readResourceLocation() : null;
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeEnum(this.action);
        if (this.action == Action.OPENED_TAB) {
            pBuffer.writeResourceLocation(this.tab);
        }
    }

    @Override
    public void handle(ServerGamePacketListener pHandler) {
        pHandler.handleSeenAdvancements(this);
    }

    public Action getAction() {
        return this.action;
    }

    @Nullable
    public ResourceLocation getTab() {
        return this.tab;
    }

    public static enum Action {
        OPENED_TAB,
        CLOSED_SCREEN;

    }
}

