/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public class ServerboundSignUpdatePacket
implements Packet<ServerGamePacketListener> {
    private static final int MAX_STRING_LENGTH = 384;
    private final BlockPos pos;
    private final String[] lines;

    public ServerboundSignUpdatePacket(BlockPos pPos, String pLine0, String pLine1, String pLine2, String pLine3) {
        this.pos = pPos;
        this.lines = new String[]{pLine0, pLine1, pLine2, pLine3};
    }

    public ServerboundSignUpdatePacket(FriendlyByteBuf pBuffer) {
        this.pos = pBuffer.readBlockPos();
        this.lines = new String[4];
        int i = 0;
        while (i < 4) {
            this.lines[i] = pBuffer.readUtf(384);
            ++i;
        }
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeBlockPos(this.pos);
        int i = 0;
        while (i < 4) {
            pBuffer.writeUtf(this.lines[i]);
            ++i;
        }
    }

    @Override
    public void handle(ServerGamePacketListener pHandler) {
        pHandler.handleSignUpdate(this);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String[] getLines() {
        return this.lines;
    }
}

