/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.core.SerializableUUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;

public class ClientboundGameProfilePacket
implements Packet<ClientLoginPacketListener> {
    private final GameProfile gameProfile;

    public ClientboundGameProfilePacket(GameProfile pGameProfile) {
        this.gameProfile = pGameProfile;
    }

    public ClientboundGameProfilePacket(FriendlyByteBuf pGameProfile) {
        int[] aint = new int[4];
        int i = 0;
        while (i < aint.length) {
            aint[i] = pGameProfile.readInt();
            ++i;
        }
        UUID uuid = SerializableUUID.a(aint);
        String s = pGameProfile.readUtf(16);
        this.gameProfile = new GameProfile(uuid, s);
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        int[] nArray = SerializableUUID.uuidToIntArray(this.gameProfile.getId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            pBuffer.writeInt(i);
            ++n2;
        }
        pBuffer.writeUtf(this.gameProfile.getName());
    }

    @Override
    public void handle(ClientLoginPacketListener pHandler) {
        pHandler.handleGameProfile(this);
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }
}

