/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;

public class ServerboundCustomQueryPacket
implements Packet<ServerLoginPacketListener> {
    private static final int MAX_PAYLOAD_SIZE = 0x100000;
    private final int transactionId;
    @Nullable
    private final FriendlyByteBuf data;

    public ServerboundCustomQueryPacket(int pTransactionId, @Nullable FriendlyByteBuf pData) {
        this.transactionId = pTransactionId;
        this.data = pData;
    }

    public ServerboundCustomQueryPacket(FriendlyByteBuf pBuffer) {
        this.transactionId = pBuffer.readVarInt();
        if (pBuffer.readBoolean()) {
            int i = pBuffer.readableBytes();
            if (i < 0 || i > 0x100000) {
                throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
            }
            this.data = new FriendlyByteBuf(pBuffer.readBytes(i));
        } else {
            this.data = null;
        }
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeVarInt(this.transactionId);
        if (this.data != null) {
            pBuffer.writeBoolean(true);
            pBuffer.writeBytes(this.data.copy());
        } else {
            pBuffer.writeBoolean(false);
        }
    }

    @Override
    public void handle(ServerLoginPacketListener pHandler) {
        pHandler.handleCustomQueryPacket(this);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @Nullable
    public FriendlyByteBuf getData() {
        return this.data;
    }
}

