/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class EntityDataSerializers {
    private static final CrudeIncrementalIntIdentityHashBiMap<EntityDataSerializer<?>> SERIALIZERS = CrudeIncrementalIntIdentityHashBiMap.create(16);
    public static final EntityDataSerializer<Byte> BYTE = new EntityDataSerializer<Byte>(){

        @Override
        public void write(FriendlyByteBuf p_135062_, Byte p_135063_) {
            p_135062_.writeByte(p_135063_.byteValue());
        }

        @Override
        public Byte read(FriendlyByteBuf p_135068_) {
            return p_135068_.readByte();
        }

        @Override
        public Byte copy(Byte p_135056_) {
            return p_135056_;
        }
    };
    public static final EntityDataSerializer<Integer> INT = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf p_135107_, Integer p_135108_) {
            p_135107_.writeVarInt(p_135108_);
        }

        @Override
        public Integer read(FriendlyByteBuf p_135113_) {
            return p_135113_.readVarInt();
        }

        @Override
        public Integer copy(Integer p_135101_) {
            return p_135101_;
        }
    };
    public static final EntityDataSerializer<Float> FLOAT = new EntityDataSerializer<Float>(){

        @Override
        public void write(FriendlyByteBuf p_135122_, Float p_135123_) {
            p_135122_.writeFloat(p_135123_.floatValue());
        }

        @Override
        public Float read(FriendlyByteBuf p_135128_) {
            return Float.valueOf(p_135128_.readFloat());
        }

        @Override
        public Float copy(Float p_135116_) {
            return p_135116_;
        }
    };
    public static final EntityDataSerializer<String> STRING = new EntityDataSerializer<String>(){

        @Override
        public void write(FriendlyByteBuf p_135140_, String p_135141_) {
            p_135140_.writeUtf(p_135141_);
        }

        @Override
        public String read(FriendlyByteBuf p_135143_) {
            return p_135143_.readUtf();
        }

        @Override
        public String copy(String p_135133_) {
            return p_135133_;
        }
    };
    public static final EntityDataSerializer<Component> COMPONENT = new EntityDataSerializer<Component>(){

        @Override
        public void write(FriendlyByteBuf p_135153_, Component p_135154_) {
            p_135153_.writeComponent(p_135154_);
        }

        @Override
        public Component read(FriendlyByteBuf p_135158_) {
            return p_135158_.readComponent();
        }

        @Override
        public Component copy(Component p_135156_) {
            return p_135156_;
        }
    };
    public static final EntityDataSerializer<Optional<Component>> OPTIONAL_COMPONENT = new EntityDataSerializer<Optional<Component>>(){

        @Override
        public void write(FriendlyByteBuf p_135170_, Optional<Component> p_135171_) {
            if (p_135171_.isPresent()) {
                p_135170_.writeBoolean(true);
                p_135170_.writeComponent(p_135171_.get());
            } else {
                p_135170_.writeBoolean(false);
            }
        }

        @Override
        public Optional<Component> read(FriendlyByteBuf p_135173_) {
            return p_135173_.readBoolean() ? Optional.of(p_135173_.readComponent()) : Optional.empty();
        }

        @Override
        public Optional<Component> copy(Optional<Component> p_135163_) {
            return p_135163_;
        }
    };
    public static final EntityDataSerializer<ItemStack> ITEM_STACK = new EntityDataSerializer<ItemStack>(){

        @Override
        public void write(FriendlyByteBuf p_135182_, ItemStack p_135183_) {
            p_135182_.writeItem(p_135183_);
        }

        @Override
        public ItemStack read(FriendlyByteBuf p_135188_) {
            return p_135188_.readItem();
        }

        @Override
        public ItemStack copy(ItemStack p_135176_) {
            return p_135176_.copy();
        }
    };
    public static final EntityDataSerializer<Optional<BlockState>> BLOCK_STATE = new EntityDataSerializer<Optional<BlockState>>(){

        @Override
        public void write(FriendlyByteBuf p_135200_, Optional<BlockState> p_135201_) {
            if (p_135201_.isPresent()) {
                p_135200_.writeVarInt(Block.getId(p_135201_.get()));
            } else {
                p_135200_.writeVarInt(0);
            }
        }

        @Override
        public Optional<BlockState> read(FriendlyByteBuf p_135203_) {
            int i = p_135203_.readVarInt();
            return i == 0 ? Optional.empty() : Optional.of(Block.stateById(i));
        }

        @Override
        public Optional<BlockState> copy(Optional<BlockState> p_135193_) {
            return p_135193_;
        }
    };
    public static final EntityDataSerializer<Boolean> BOOLEAN = new EntityDataSerializer<Boolean>(){

        @Override
        public void write(FriendlyByteBuf p_135212_, Boolean p_135213_) {
            p_135212_.writeBoolean(p_135213_);
        }

        @Override
        public Boolean read(FriendlyByteBuf p_135218_) {
            return p_135218_.readBoolean();
        }

        @Override
        public Boolean copy(Boolean p_135206_) {
            return p_135206_;
        }
    };
    public static final EntityDataSerializer<ParticleOptions> PARTICLE = new EntityDataSerializer<ParticleOptions>(){

        @Override
        public void write(FriendlyByteBuf p_135227_, ParticleOptions p_135228_) {
            p_135227_.writeVarInt(Registry.PARTICLE_TYPE.getId(p_135228_.getType()));
            p_135228_.writeToNetwork(p_135227_);
        }

        @Override
        public ParticleOptions read(FriendlyByteBuf p_135236_) {
            return this.readParticle(p_135236_, (ParticleType)Registry.PARTICLE_TYPE.byId(p_135236_.readVarInt()));
        }

        private <T extends ParticleOptions> T readParticle(FriendlyByteBuf p_135230_, ParticleType<T> p_135231_) {
            return p_135231_.getDeserializer().fromNetwork(p_135231_, p_135230_);
        }

        @Override
        public ParticleOptions copy(ParticleOptions p_135221_) {
            return p_135221_;
        }
    };
    public static final EntityDataSerializer<Rotations> ROTATIONS = new EntityDataSerializer<Rotations>(){

        @Override
        public void write(FriendlyByteBuf p_135245_, Rotations p_135246_) {
            p_135245_.writeFloat(p_135246_.getX());
            p_135245_.writeFloat(p_135246_.getY());
            p_135245_.writeFloat(p_135246_.getZ());
        }

        @Override
        public Rotations read(FriendlyByteBuf p_135251_) {
            return new Rotations(p_135251_.readFloat(), p_135251_.readFloat(), p_135251_.readFloat());
        }

        @Override
        public Rotations copy(Rotations p_135239_) {
            return p_135239_;
        }
    };
    public static final EntityDataSerializer<BlockPos> BLOCK_POS = new EntityDataSerializer<BlockPos>(){

        @Override
        public void write(FriendlyByteBuf p_135260_, BlockPos p_135261_) {
            p_135260_.writeBlockPos(p_135261_);
        }

        @Override
        public BlockPos read(FriendlyByteBuf p_135266_) {
            return p_135266_.readBlockPos();
        }

        @Override
        public BlockPos copy(BlockPos p_135254_) {
            return p_135254_;
        }
    };
    public static final EntityDataSerializer<Optional<BlockPos>> OPTIONAL_BLOCK_POS = new EntityDataSerializer<Optional<BlockPos>>(){

        @Override
        public void write(FriendlyByteBuf p_135278_, Optional<BlockPos> p_135279_) {
            p_135278_.writeBoolean(p_135279_.isPresent());
            if (p_135279_.isPresent()) {
                p_135278_.writeBlockPos(p_135279_.get());
            }
        }

        @Override
        public Optional<BlockPos> read(FriendlyByteBuf p_135281_) {
            return !p_135281_.readBoolean() ? Optional.empty() : Optional.of(p_135281_.readBlockPos());
        }

        @Override
        public Optional<BlockPos> copy(Optional<BlockPos> p_135271_) {
            return p_135271_;
        }
    };
    public static final EntityDataSerializer<Direction> DIRECTION = new EntityDataSerializer<Direction>(){

        @Override
        public void write(FriendlyByteBuf p_135290_, Direction p_135291_) {
            p_135290_.writeEnum(p_135291_);
        }

        @Override
        public Direction read(FriendlyByteBuf p_135296_) {
            return p_135296_.readEnum(Direction.class);
        }

        @Override
        public Direction copy(Direction p_135284_) {
            return p_135284_;
        }
    };
    public static final EntityDataSerializer<Optional<UUID>> OPTIONAL_UUID = new EntityDataSerializer<Optional<UUID>>(){

        @Override
        public void write(FriendlyByteBuf p_135308_, Optional<UUID> p_135309_) {
            p_135308_.writeBoolean(p_135309_.isPresent());
            if (p_135309_.isPresent()) {
                p_135308_.writeUUID(p_135309_.get());
            }
        }

        @Override
        public Optional<UUID> read(FriendlyByteBuf p_135311_) {
            return !p_135311_.readBoolean() ? Optional.empty() : Optional.of(p_135311_.readUUID());
        }

        @Override
        public Optional<UUID> copy(Optional<UUID> p_135301_) {
            return p_135301_;
        }
    };
    public static final EntityDataSerializer<CompoundTag> COMPOUND_TAG = new EntityDataSerializer<CompoundTag>(){

        @Override
        public void write(FriendlyByteBuf p_135323_, CompoundTag p_135324_) {
            p_135323_.writeNbt(p_135324_);
        }

        @Override
        public CompoundTag read(FriendlyByteBuf p_135326_) {
            return p_135326_.readNbt();
        }

        @Override
        public CompoundTag copy(CompoundTag p_135316_) {
            return p_135316_.copy();
        }
    };
    public static final EntityDataSerializer<VillagerData> VILLAGER_DATA = new EntityDataSerializer<VillagerData>(){

        @Override
        public void write(FriendlyByteBuf p_135335_, VillagerData p_135336_) {
            p_135335_.writeVarInt(Registry.VILLAGER_TYPE.getId(p_135336_.getType()));
            p_135335_.writeVarInt(Registry.VILLAGER_PROFESSION.getId(p_135336_.getProfession()));
            p_135335_.writeVarInt(p_135336_.getLevel());
        }

        @Override
        public VillagerData read(FriendlyByteBuf p_135341_) {
            return new VillagerData(Registry.VILLAGER_TYPE.byId(p_135341_.readVarInt()), Registry.VILLAGER_PROFESSION.byId(p_135341_.readVarInt()), p_135341_.readVarInt());
        }

        @Override
        public VillagerData copy(VillagerData p_135329_) {
            return p_135329_;
        }
    };
    public static final EntityDataSerializer<OptionalInt> OPTIONAL_UNSIGNED_INT = new EntityDataSerializer<OptionalInt>(){

        @Override
        public void write(FriendlyByteBuf p_135080_, OptionalInt p_135081_) {
            p_135080_.writeVarInt(p_135081_.orElse(-1) + 1);
        }

        @Override
        public OptionalInt read(FriendlyByteBuf p_135083_) {
            int i = p_135083_.readVarInt();
            return i == 0 ? OptionalInt.empty() : OptionalInt.of(i - 1);
        }

        @Override
        public OptionalInt copy(OptionalInt p_135073_) {
            return p_135073_;
        }
    };
    public static final EntityDataSerializer<Pose> POSE = new EntityDataSerializer<Pose>(){

        @Override
        public void write(FriendlyByteBuf p_135092_, Pose p_135093_) {
            p_135092_.writeEnum(p_135093_);
        }

        @Override
        public Pose read(FriendlyByteBuf p_135098_) {
            return p_135098_.readEnum(Pose.class);
        }

        @Override
        public Pose copy(Pose p_135086_) {
            return p_135086_;
        }
    };

    static {
        EntityDataSerializers.registerSerializer(BYTE);
        EntityDataSerializers.registerSerializer(INT);
        EntityDataSerializers.registerSerializer(FLOAT);
        EntityDataSerializers.registerSerializer(STRING);
        EntityDataSerializers.registerSerializer(COMPONENT);
        EntityDataSerializers.registerSerializer(OPTIONAL_COMPONENT);
        EntityDataSerializers.registerSerializer(ITEM_STACK);
        EntityDataSerializers.registerSerializer(BOOLEAN);
        EntityDataSerializers.registerSerializer(ROTATIONS);
        EntityDataSerializers.registerSerializer(BLOCK_POS);
        EntityDataSerializers.registerSerializer(OPTIONAL_BLOCK_POS);
        EntityDataSerializers.registerSerializer(DIRECTION);
        EntityDataSerializers.registerSerializer(OPTIONAL_UUID);
        EntityDataSerializers.registerSerializer(BLOCK_STATE);
        EntityDataSerializers.registerSerializer(COMPOUND_TAG);
        EntityDataSerializers.registerSerializer(PARTICLE);
        EntityDataSerializers.registerSerializer(VILLAGER_DATA);
        EntityDataSerializers.registerSerializer(OPTIONAL_UNSIGNED_INT);
        EntityDataSerializers.registerSerializer(POSE);
    }

    public static void registerSerializer(EntityDataSerializer<?> pSerializer) {
        SERIALIZERS.add(pSerializer);
    }

    @Nullable
    public static EntityDataSerializer<?> getSerializer(int pId) {
        return SERIALIZERS.byId(pId);
    }

    public static int getSerializedId(EntityDataSerializer<?> pSerializer) {
        return SERIALIZERS.getId(pSerializer);
    }

    private EntityDataSerializers() {
    }
}

