/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.optifine.util.BiomeUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class SynchedEntityData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Object2IntMap<Class<? extends Entity>> ENTITY_ID_POOL = new Object2IntOpenHashMap();
    private static final int EOF_MARKER = 255;
    private static final int MAX_ID_VALUE = 254;
    private final Entity entity;
    private final Int2ObjectMap<DataItem<?>> itemsById = new Int2ObjectOpenHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean isEmpty = true;
    private boolean isDirty;
    public Biome spawnBiome = BiomeUtils.PLAINS;
    public BlockPos spawnPosition = BlockPos.ZERO;

    public SynchedEntityData(Entity p_135351_) {
        this.entity = p_135351_;
    }

    public static <T> EntityDataAccessor<T> defineId(Class<? extends Entity> pClazz, EntityDataSerializer<T> pSerializer) {
        int j;
        if (LOGGER.isDebugEnabled()) {
            try {
                Class<?> oclass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass.equals(pClazz)) {
                    LOGGER.debug("defineId called for: {} from {}", new Object[]{pClazz, oclass, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException oclass) {
                // empty catch block
            }
        }
        if (ENTITY_ID_POOL.containsKey(pClazz)) {
            j = ENTITY_ID_POOL.getInt(pClazz) + 1;
        } else {
            int i = 0;
            Class<? extends Entity> oclass1 = pClazz;
            while (oclass1 != Entity.class) {
                if (!ENTITY_ID_POOL.containsKey(oclass1 = oclass1.getSuperclass())) continue;
                i = ENTITY_ID_POOL.getInt(oclass1) + 1;
                break;
            }
            j = i;
        }
        if (j > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + j + "! (Max is 254)");
        }
        ENTITY_ID_POOL.put(pClazz, j);
        return pSerializer.createAccessor(j);
    }

    public <T> void define(EntityDataAccessor<T> pKey, T pValue) {
        int i = pKey.getId();
        if (i > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i + "! (Max is 254)");
        }
        if (this.itemsById.containsKey(i)) {
            throw new IllegalArgumentException("Duplicate id value for " + i + "!");
        }
        if (EntityDataSerializers.getSerializedId(pKey.getSerializer()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + pKey.getSerializer() + " for " + i + "!");
        }
        this.createDataItem(pKey, pValue);
    }

    private <T> void createDataItem(EntityDataAccessor<T> pKey, T pValue) {
        DataItem<T> dataitem = new DataItem<T>(pKey, pValue);
        this.lock.writeLock().lock();
        this.itemsById.put(pKey.getId(), dataitem);
        this.isEmpty = false;
        this.lock.writeLock().unlock();
    }

    private <T> DataItem<T> getItem(EntityDataAccessor<T> pKey) {
        DataItem dataitem;
        this.lock.readLock().lock();
        try {
            try {
                dataitem = (DataItem)this.itemsById.get(pKey.getId());
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Getting synched entity data");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Synched entity data");
                crashreportcategory.setDetail("Data ID", pKey);
                throw new ReportedException(crashreport);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return dataitem;
    }

    public <T> T get(EntityDataAccessor<T> pKey) {
        return this.getItem(pKey).getValue();
    }

    public <T> void set(EntityDataAccessor<T> pKey, T pValue) {
        DataItem<T> dataitem = this.getItem(pKey);
        if (ObjectUtils.notEqual(pValue, dataitem.getValue())) {
            dataitem.setValue(pValue);
            this.entity.onSyncedDataUpdated(pKey);
            dataitem.setDirty(true);
            this.isDirty = true;
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public static void pack(@Nullable List<DataItem<?>> pEntries, FriendlyByteBuf pBuffer) {
        if (pEntries != null) {
            for (DataItem<?> dataitem : pEntries) {
                SynchedEntityData.writeDataItem(pBuffer, dataitem);
            }
        }
        pBuffer.writeByte(255);
    }

    @Nullable
    public List<DataItem<?>> packDirty() {
        ArrayList list = null;
        if (this.isDirty) {
            this.lock.readLock().lock();
            for (DataItem dataitem : this.itemsById.values()) {
                if (!dataitem.isDirty()) continue;
                dataitem.setDirty(false);
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(dataitem.copy());
            }
            this.lock.readLock().unlock();
        }
        this.isDirty = false;
        return list;
    }

    @Nullable
    public List<DataItem<?>> getAll() {
        ArrayList list = null;
        this.lock.readLock().lock();
        for (DataItem dataitem : this.itemsById.values()) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(dataitem.copy());
        }
        this.lock.readLock().unlock();
        return list;
    }

    private static <T> void writeDataItem(FriendlyByteBuf pBuffer, DataItem<T> pEntry) {
        EntityDataAccessor<T> entitydataaccessor = pEntry.getAccessor();
        int i = EntityDataSerializers.getSerializedId(entitydataaccessor.getSerializer());
        if (i < 0) {
            throw new EncoderException("Unknown serializer type " + entitydataaccessor.getSerializer());
        }
        pBuffer.writeByte(entitydataaccessor.getId());
        pBuffer.writeVarInt(i);
        entitydataaccessor.getSerializer().write(pBuffer, pEntry.getValue());
    }

    @Nullable
    public static List<DataItem<?>> unpack(FriendlyByteBuf pBuffer) {
        short i;
        ArrayList list = null;
        while ((i = pBuffer.readUnsignedByte()) != 255) {
            int j;
            EntityDataSerializer<?> entitydataserializer;
            if (list == null) {
                list = Lists.newArrayList();
            }
            if ((entitydataserializer = EntityDataSerializers.getSerializer(j = pBuffer.readVarInt())) == null) {
                throw new DecoderException("Unknown serializer type " + j);
            }
            list.add(SynchedEntityData.genericHelper(pBuffer, i, entitydataserializer));
        }
        return list;
    }

    private static <T> DataItem<T> genericHelper(FriendlyByteBuf pBuffer, int pId, EntityDataSerializer<T> pSerializer) {
        return new DataItem<T>(pSerializer.createAccessor(pId), pSerializer.read(pBuffer));
    }

    public void assignValues(List<DataItem<?>> pEntries) {
        this.lock.writeLock().lock();
        try {
            for (DataItem<?> dataitem : pEntries) {
                DataItem dataitem1 = (DataItem)this.itemsById.get(dataitem.getAccessor().getId());
                if (dataitem1 == null) continue;
                this.assignValue(dataitem1, dataitem);
                this.entity.onSyncedDataUpdated(dataitem.getAccessor());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.isDirty = true;
    }

    private <T> void assignValue(DataItem<T> pTarget, DataItem<?> pSource) {
        if (!Objects.equals(pSource.accessor.getSerializer(), pTarget.accessor.getSerializer())) {
            throw new IllegalStateException(String.format("Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", pTarget.accessor.getId(), this.entity, pTarget.value, pTarget.value.getClass(), pSource.value, pSource.value.getClass()));
        }
        pTarget.setValue(pSource.getValue());
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void clearDirty() {
        this.isDirty = false;
        this.lock.readLock().lock();
        for (DataItem dataitem : this.itemsById.values()) {
            dataitem.setDirty(false);
        }
        this.lock.readLock().unlock();
    }

    public static class DataItem<T> {
        final EntityDataAccessor<T> accessor;
        T value;
        private boolean dirty;

        public DataItem(EntityDataAccessor<T> pAccessor, T pValue) {
            this.accessor = pAccessor;
            this.value = pValue;
            this.dirty = true;
        }

        public EntityDataAccessor<T> getAccessor() {
            return this.accessor;
        }

        public void setValue(T pValue) {
            this.value = pValue;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean pDirty) {
            this.dirty = pDirty;
        }

        public DataItem<T> copy() {
            return new DataItem<T>(this.accessor, this.accessor.getSerializer().copy(this.value));
        }
    }
}

