/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.slf4j.Logger;

public class ServerPlaceRecipe<C extends Container>
implements PlaceRecipe<Integer> {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final StackedContents stackedContents = new StackedContents();
    protected Inventory inventory;
    protected RecipeBookMenu<C> menu;

    public ServerPlaceRecipe(RecipeBookMenu<C> p_135431_) {
        this.menu = p_135431_;
    }

    public void recipeClicked(ServerPlayer pPlayer, @Nullable Recipe<C> pRecipe, boolean pPlaceAll) {
        if (pRecipe != null && pPlayer.getRecipeBook().contains(pRecipe)) {
            this.inventory = pPlayer.getInventory();
            if (this.testClearGrid() || pPlayer.isCreative()) {
                this.stackedContents.clear();
                pPlayer.getInventory().fillStackedContents(this.stackedContents);
                this.menu.fillCraftSlotsStackedContents(this.stackedContents);
                if (this.stackedContents.canCraft(pRecipe, null)) {
                    this.handleRecipeClicked(pRecipe, pPlaceAll);
                } else {
                    this.clearGrid(true);
                    pPlayer.connection.send(new ClientboundPlaceGhostRecipePacket(pPlayer.containerMenu.containerId, pRecipe));
                }
                pPlayer.getInventory().setChanged();
            }
        }
    }

    protected void clearGrid(boolean p_179845_) {
        int i = 0;
        while (i < this.menu.getSize()) {
            if (this.menu.shouldMoveToInventory(i)) {
                ItemStack itemstack = this.menu.getSlot(i).getItem().copy();
                this.inventory.placeItemBackInInventory(itemstack, false);
                this.menu.getSlot(i).set(itemstack);
            }
            ++i;
        }
        this.menu.clearCraftingContent();
    }

    protected void handleRecipeClicked(Recipe<C> pRecipe, boolean pPlaceAll) {
        int j1;
        IntArrayList intlist;
        boolean flag = this.menu.recipeMatches(pRecipe);
        int i = this.stackedContents.getBiggestCraftableStack(pRecipe, null);
        if (flag) {
            int j = 0;
            while (j < this.menu.getGridHeight() * this.menu.getGridWidth() + 1) {
                ItemStack itemstack;
                if (j != this.menu.getResultSlotIndex() && !(itemstack = this.menu.getSlot(j).getItem()).isEmpty() && Math.min(i, itemstack.getMaxStackSize()) < itemstack.getCount() + 1) {
                    return;
                }
                ++j;
            }
        }
        if (this.stackedContents.canCraft(pRecipe, (IntList)(intlist = new IntArrayList()), j1 = this.getStackSize(pPlaceAll, i, flag))) {
            int k = j1;
            Iterator iterator = intlist.iterator();
            while (iterator.hasNext()) {
                int l = (Integer)iterator.next();
                int i1 = StackedContents.fromStackingIndex(l).getMaxStackSize();
                if (i1 >= k) continue;
                k = i1;
            }
            if (this.stackedContents.canCraft(pRecipe, (IntList)intlist, k)) {
                this.clearGrid(false);
                this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), pRecipe, intlist.iterator(), k);
            }
        }
    }

    @Override
    public void addItemToSlot(Iterator<Integer> pIngredients, int pSlot, int pMaxAmount, int pY, int pX) {
        Slot slot = this.menu.getSlot(pSlot);
        ItemStack itemstack = StackedContents.fromStackingIndex(pIngredients.next());
        if (!itemstack.isEmpty()) {
            int i = 0;
            while (i < pMaxAmount) {
                this.moveItemToGrid(slot, itemstack);
                ++i;
            }
        }
    }

    protected int getStackSize(boolean pPlaceAll, int pMaxPossible, boolean pRecipeMatches) {
        int i = 1;
        if (pPlaceAll) {
            i = pMaxPossible;
        } else if (pRecipeMatches) {
            i = 64;
            int j = 0;
            while (j < this.menu.getGridWidth() * this.menu.getGridHeight() + 1) {
                ItemStack itemstack;
                if (j != this.menu.getResultSlotIndex() && !(itemstack = this.menu.getSlot(j).getItem()).isEmpty() && i > itemstack.getCount()) {
                    i = itemstack.getCount();
                }
                ++j;
            }
            if (i < 64) {
                ++i;
            }
        }
        return i;
    }

    protected void moveItemToGrid(Slot pSlotToFill, ItemStack pIngredient) {
        ItemStack itemstack;
        int i = this.inventory.findSlotMatchingUnusedItem(pIngredient);
        if (i != -1 && !(itemstack = this.inventory.getItem(i).copy()).isEmpty()) {
            if (itemstack.getCount() > 1) {
                this.inventory.removeItem(i, 1);
            } else {
                this.inventory.removeItemNoUpdate(i);
            }
            itemstack.setCount(1);
            if (pSlotToFill.getItem().isEmpty()) {
                pSlotToFill.set(itemstack);
            } else {
                pSlotToFill.getItem().grow(1);
            }
        }
    }

    private boolean testClearGrid() {
        ArrayList list = Lists.newArrayList();
        int i = this.getAmountOfFreeSlotsInInventory();
        int j = 0;
        while (j < this.menu.getGridWidth() * this.menu.getGridHeight() + 1) {
            ItemStack itemstack;
            if (j != this.menu.getResultSlotIndex() && !(itemstack = this.menu.getSlot(j).getItem().copy()).isEmpty()) {
                int k = this.inventory.getSlotWithRemainingSpace(itemstack);
                if (k == -1 && list.size() <= i) {
                    for (ItemStack itemstack1 : list) {
                        if (!itemstack1.sameItem(itemstack) || itemstack1.getCount() == itemstack1.getMaxStackSize() || itemstack1.getCount() + itemstack.getCount() > itemstack1.getMaxStackSize()) continue;
                        itemstack1.grow(itemstack.getCount());
                        itemstack.setCount(0);
                        break;
                    }
                    if (!itemstack.isEmpty()) {
                        if (list.size() >= i) {
                            return false;
                        }
                        list.add(itemstack);
                    }
                } else if (k == -1) {
                    return false;
                }
            }
            ++j;
        }
        return true;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int i = 0;
        for (ItemStack itemstack : this.inventory.items) {
            if (!itemstack.isEmpty()) continue;
            ++i;
        }
        return i;
    }
}

