/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class HolderSetCodec<E>
implements Codec<HolderSet<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;
    private final Codec<Holder<E>> elementCodec;
    private final Codec<List<Holder<E>>> homogenousListCodec;
    private final Codec<Either<TagKey<E>, List<Holder<E>>>> registryAwareCodec;

    private static <E> Codec<List<Holder<E>>> homogenousList(Codec<Holder<E>> p_206668_, boolean p_206669_) {
        Function function = ExtraCodecs.ensureHomogenous(Holder::kind);
        Codec codec = p_206668_.listOf().flatXmap(function, function);
        return p_206669_ ? codec : Codec.either((Codec)codec, p_206668_).xmap(p_206664_ -> (List)p_206664_.map(p_206694_ -> p_206694_, List::of), p_206684_ -> p_206684_.size() == 1 ? Either.right((Object)((Holder)p_206684_.get(0))) : Either.left((Object)p_206684_));
    }

    public static <E> Codec<HolderSet<E>> create(ResourceKey<? extends Registry<E>> p_206686_, Codec<Holder<E>> p_206687_, boolean p_206688_) {
        return new HolderSetCodec<E>(p_206686_, p_206687_, p_206688_);
    }

    private HolderSetCodec(ResourceKey<? extends Registry<E>> p_206660_, Codec<Holder<E>> p_206661_, boolean p_206662_) {
        this.registryKey = p_206660_;
        this.elementCodec = p_206661_;
        this.homogenousListCodec = HolderSetCodec.homogenousList(p_206661_, p_206662_);
        this.registryAwareCodec = Codec.either(TagKey.hashedCodec(p_206660_), this.homogenousListCodec);
    }

    public <T> DataResult<Pair<HolderSet<E>, T>> decode(DynamicOps<T> p_206696_, T p_206697_) {
        RegistryOps registryops;
        Optional optional;
        if (p_206696_ instanceof RegistryOps && (optional = (registryops = (RegistryOps)p_206696_).registry(this.registryKey)).isPresent()) {
            Registry registry = optional.get();
            return this.registryAwareCodec.decode(p_206696_, p_206697_).map(p_206682_ -> p_206682_.mapFirst(p_206679_ -> (HolderSet)p_206679_.map(registry::getOrCreateTag, HolderSet::direct)));
        }
        return this.decodeWithoutRegistry(p_206696_, p_206697_);
    }

    public <T> DataResult<T> encode(HolderSet<E> p_206674_, DynamicOps<T> p_206675_, T p_206676_) {
        RegistryOps registryops;
        Optional optional;
        if (p_206675_ instanceof RegistryOps && (optional = (registryops = (RegistryOps)p_206675_).registry(this.registryKey)).isPresent()) {
            if (!p_206674_.isValidInRegistry(optional.get())) {
                return DataResult.error((String)("HolderSet " + p_206674_ + " is not valid in current registry set"));
            }
            return this.registryAwareCodec.encode((Object)p_206674_.unwrap().mapRight(List::copyOf), p_206675_, p_206676_);
        }
        return this.encodeWithoutRegistry(p_206674_, p_206675_, p_206676_);
    }

    private <T> DataResult<Pair<HolderSet<E>, T>> decodeWithoutRegistry(DynamicOps<T> p_206671_, T p_206672_) {
        return this.elementCodec.listOf().decode(p_206671_, p_206672_).flatMap(p_206666_ -> {
            ArrayList<Holder.Direct> list = new ArrayList<Holder.Direct>();
            for (Holder holder : (List)p_206666_.getFirst()) {
                if (!(holder instanceof Holder.Direct)) {
                    return DataResult.error((String)("Can't decode element " + holder + " without registry"));
                }
                Holder.Direct direct = (Holder.Direct)holder;
                list.add(direct);
            }
            return DataResult.success((Object)new Pair(HolderSet.direct(list), p_206666_.getSecond()));
        });
    }

    private <T> DataResult<T> encodeWithoutRegistry(HolderSet<E> p_206690_, DynamicOps<T> p_206691_, T p_206692_) {
        return this.homogenousListCodec.encode(p_206690_.stream().toList(), p_206691_, p_206692_);
    }
}

