/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class RegistryFileCodec<E>
implements Codec<Holder<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;
    private final Codec<E> elementCodec;
    private final boolean allowInline;

    public static <E> RegistryFileCodec<E> create(ResourceKey<? extends Registry<E>> pRegistryKey, Codec<E> pElementCodec) {
        return RegistryFileCodec.create(pRegistryKey, pElementCodec, true);
    }

    private static <E> RegistryFileCodec<E> create(ResourceKey<? extends Registry<E>> pRegistryKey, Codec<E> pElementCodec, boolean pAllowInline) {
        return new RegistryFileCodec<E>(pRegistryKey, pElementCodec, pAllowInline);
    }

    private RegistryFileCodec(ResourceKey<? extends Registry<E>> pRegistryKey, Codec<E> pElementCodec, boolean pAllowInline) {
        this.registryKey = pRegistryKey;
        this.elementCodec = pElementCodec;
        this.allowInline = pAllowInline;
    }

    public <T> DataResult<T> encode(Holder<E> pInput, DynamicOps<T> pOps, T pPrefix) {
        RegistryOps registryops;
        Optional optional;
        if (pOps instanceof RegistryOps && (optional = (registryops = (RegistryOps)pOps).registry(this.registryKey)).isPresent()) {
            if (!pInput.isValidInRegistry(optional.get())) {
                return DataResult.error((String)("Element " + pInput + " is not valid in current registry set"));
            }
            return (DataResult)pInput.unwrap().map(p_206714_ -> ResourceLocation.CODEC.encode((Object)p_206714_.location(), pOps, pPrefix), p_206710_ -> this.elementCodec.encode(p_206710_, pOps, pPrefix));
        }
        return this.elementCodec.encode(pInput.value(), pOps, pPrefix);
    }

    public <T> DataResult<Pair<Holder<E>, T>> decode(DynamicOps<T> pOps, T pInput) {
        if (pOps instanceof RegistryOps) {
            RegistryOps registryops = (RegistryOps)pOps;
            Optional optional = registryops.registry(this.registryKey);
            if (optional.isEmpty()) {
                return DataResult.error((String)("Registry does not exist: " + this.registryKey));
            }
            Registry registry = optional.get();
            DataResult dataresult = ResourceLocation.CODEC.decode(pOps, pInput);
            if (dataresult.result().isEmpty()) {
                return !this.allowInline ? DataResult.error((String)"Inline definitions not allowed here") : this.elementCodec.decode(pOps, pInput).map(p_206720_ -> p_206720_.mapFirst(Holder::direct));
            }
            Pair pair = (Pair)dataresult.result().get();
            ResourceKey resourcekey = ResourceKey.create(this.registryKey, (ResourceLocation)pair.getFirst());
            Optional<RegistryLoader.Bound> optional1 = registryops.registryLoader();
            if (optional1.isPresent()) {
                return optional1.get().overrideElementFromResources(this.registryKey, this.elementCodec, resourcekey, registryops.getAsJson()).map(p_206706_ -> Pair.of((Object)p_206706_, (Object)pair.getSecond()));
            }
            Holder holder = registry.getOrCreateHolder(resourcekey);
            return DataResult.success((Object)Pair.of(holder, (Object)pair.getSecond()), (Lifecycle)Lifecycle.stable());
        }
        return this.elementCodec.decode(pOps, pInput).map(p_206703_ -> p_206703_.mapFirst(Holder::direct));
    }

    public String toString() {
        return "RegistryFileCodec[" + this.registryKey + " " + this.elementCodec + "]";
    }
}

