/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class RegistryFixedCodec<E>
implements Codec<Holder<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;

    public static <E> RegistryFixedCodec<E> create(ResourceKey<? extends Registry<E>> p_206741_) {
        return new RegistryFixedCodec<E>(p_206741_);
    }

    private RegistryFixedCodec(ResourceKey<? extends Registry<E>> p_206723_) {
        this.registryKey = p_206723_;
    }

    public <T> DataResult<T> encode(Holder<E> p_206729_, DynamicOps<T> p_206730_, T p_206731_) {
        RegistryOps registryops;
        Optional optional;
        if (p_206730_ instanceof RegistryOps && (optional = (registryops = (RegistryOps)p_206730_).registry(this.registryKey)).isPresent()) {
            if (!p_206729_.isValidInRegistry(optional.get())) {
                return DataResult.error((String)("Element " + p_206729_ + " is not valid in current registry set"));
            }
            return (DataResult)p_206729_.unwrap().map(p_206727_ -> ResourceLocation.CODEC.encode((Object)p_206727_.location(), p_206730_, p_206731_), p_206733_ -> DataResult.error((String)("Elements from registry " + this.registryKey + " can't be serialized to a value")));
        }
        return DataResult.error((String)("Can't access registry " + this.registryKey));
    }

    public <T> DataResult<Pair<Holder<E>, T>> decode(DynamicOps<T> p_206743_, T p_206744_) {
        RegistryOps registryops;
        Optional optional;
        if (p_206743_ instanceof RegistryOps && (optional = (registryops = (RegistryOps)p_206743_).registry(this.registryKey)).isPresent()) {
            return ResourceLocation.CODEC.decode(p_206743_, p_206744_).map(p_206736_ -> p_206736_.mapFirst(p_206739_ -> ((Registry)optional.get()).getOrCreateHolder(ResourceKey.create(this.registryKey, p_206739_))));
        }
        return DataResult.error((String)("Can't access registry " + this.registryKey));
    }

    public String toString() {
        return "RegistryFixedCodec[" + this.registryKey + "]";
    }
}

