/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;

public class RegistryLoader {
    private final RegistryResourceAccess resources;
    private final Map<ResourceKey<? extends Registry<?>>, ReadCache<?>> readCache = new IdentityHashMap();

    RegistryLoader(RegistryResourceAccess p_206753_) {
        this.resources = p_206753_;
    }

    public <E> DataResult<? extends Registry<E>> overrideRegistryFromResources(WritableRegistry<E> p_206763_, ResourceKey<? extends Registry<E>> p_206764_, Codec<E> p_206765_, DynamicOps<JsonElement> p_206766_) {
        Collection collection = this.resources.listResources(p_206764_);
        DataResult dataresult = DataResult.success(p_206763_, (Lifecycle)Lifecycle.stable());
        for (ResourceKey resourcekey : collection) {
            dataresult = dataresult.flatMap(p_206780_ -> this.overrideElementFromResources((WritableRegistry)p_206780_, p_206764_, p_206765_, resourcekey, p_206766_).map(p_206761_ -> p_206780_));
        }
        return dataresult.setPartial(p_206763_);
    }

    <E> DataResult<Holder<E>> overrideElementFromResources(WritableRegistry<E> p_206768_, ResourceKey<? extends Registry<E>> p_206769_, Codec<E> p_206770_, ResourceKey<E> p_206771_, DynamicOps<JsonElement> p_206772_) {
        DataResult dataresult1;
        ReadCache<E> readcache = this.readCache(p_206769_);
        DataResult dataresult = readcache.values.get(p_206771_);
        if (dataresult != null) {
            return dataresult;
        }
        Holder holder = p_206768_.getOrCreateHolder(p_206771_);
        readcache.values.put(p_206771_, DataResult.success(holder));
        Optional<DataResult<RegistryResourceAccess.ParsedEntry<E>>> optional = this.resources.parseElement(p_206772_, p_206769_, p_206771_, p_206770_);
        if (optional.isEmpty()) {
            dataresult1 = p_206768_.containsKey(p_206771_) ? DataResult.success(holder, (Lifecycle)Lifecycle.stable()) : DataResult.error((String)("Missing referenced custom/removed registry entry for registry " + p_206769_ + " named " + p_206771_.location()));
        } else {
            DataResult<RegistryResourceAccess.ParsedEntry<E>> dataresult2 = optional.get();
            Optional optional1 = dataresult2.result();
            if (optional1.isPresent()) {
                RegistryResourceAccess.ParsedEntry parsedentry = (RegistryResourceAccess.ParsedEntry)optional1.get();
                p_206768_.registerOrOverride(parsedentry.fixedId(), p_206771_, parsedentry.value(), dataresult2.lifecycle());
            }
            dataresult1 = dataresult2.map(p_206756_ -> holder);
        }
        readcache.values.put(p_206771_, dataresult1);
        return dataresult1;
    }

    private <E> ReadCache<E> readCache(ResourceKey<? extends Registry<E>> p_206774_) {
        return this.readCache.computeIfAbsent(p_206774_, p_206782_ -> new ReadCache());
    }

    public Bound bind(RegistryAccess.Writable p_206758_) {
        return new Bound(p_206758_, this);
    }

    public record Bound(RegistryAccess.Writable access, RegistryLoader loader) {
        public <E> DataResult<? extends Registry<E>> overrideRegistryFromResources(ResourceKey<? extends Registry<E>> p_206790_, Codec<E> p_206791_, DynamicOps<JsonElement> p_206792_) {
            WritableRegistry writableregistry = this.access.ownedWritableRegistryOrThrow(p_206790_);
            return this.loader.overrideRegistryFromResources(writableregistry, p_206790_, p_206791_, p_206792_);
        }

        public <E> DataResult<Holder<E>> overrideElementFromResources(ResourceKey<? extends Registry<E>> p_206794_, Codec<E> p_206795_, ResourceKey<E> p_206796_, DynamicOps<JsonElement> p_206797_) {
            WritableRegistry writableregistry = this.access.ownedWritableRegistryOrThrow(p_206794_);
            return this.loader.overrideElementFromResources(writableregistry, p_206794_, p_206795_, p_206796_, p_206797_);
        }
    }

    static final class ReadCache<E> {
        final Map<ResourceKey<E>, DataResult<Holder<E>>> values = Maps.newIdentityHashMap();

        ReadCache() {
        }
    }
}

