/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.selector.options.EntitySelectorOptions;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.locale.Language;
import net.minecraft.server.DebugLoggedPrintStream;
import net.minecraft.server.LoggedPrintStream;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;

public class Bootstrap {
    public static final PrintStream STDOUT = System.out;
    private static volatile boolean isBootstrapped;
    private static final Logger LOGGER;

    static {
        LOGGER = LogUtils.getLogger();
    }

    public static void bootStrap() {
        if (!isBootstrapped) {
            isBootstrapped = true;
            if (Registry.REGISTRY.keySet().isEmpty()) {
                throw new IllegalStateException("Unable to load registries");
            }
            FireBlock.bootStrap();
            ComposterBlock.bootStrap();
            if (EntityType.getKey(EntityType.PLAYER) == null) {
                throw new IllegalStateException("Failed loading EntityTypes");
            }
            PotionBrewing.bootStrap();
            EntitySelectorOptions.bootStrap();
            DispenseItemBehavior.bootStrap();
            CauldronInteraction.bootStrap();
            ArgumentTypes.bootStrap();
            Registry.freezeBuiltins();
            Bootstrap.wrapStreams();
        }
    }

    private static <T> void checkTranslations(Iterable<T> pObjects, Function<T, String> pObjectToKeyFunction, Set<String> pTranslationSet) {
        Language language = Language.getInstance();
        pObjects.forEach(p_135883_ -> {
            String s = (String)pObjectToKeyFunction.apply(p_135883_);
            if (!language.has(s)) {
                pTranslationSet.add(s);
            }
        });
    }

    private static void checkGameruleTranslations(Set<String> pTranslations) {
        Language language = Language.getInstance();
        GameRules.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            @Override
            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> p_135897_, GameRules.Type<T> p_135898_) {
                if (!language.has(p_135897_.getDescriptionId())) {
                    pTranslations.add(p_135897_.getId());
                }
            }
        });
    }

    public static Set<String> getMissingTranslations() {
        TreeSet<String> set = new TreeSet<String>();
        Bootstrap.checkTranslations(Registry.ATTRIBUTE, Attribute::getDescriptionId, set);
        Bootstrap.checkTranslations(Registry.ENTITY_TYPE, EntityType::getDescriptionId, set);
        Bootstrap.checkTranslations(Registry.MOB_EFFECT, MobEffect::getDescriptionId, set);
        Bootstrap.checkTranslations(Registry.ITEM, Item::getDescriptionId, set);
        Bootstrap.checkTranslations(Registry.ENCHANTMENT, Enchantment::getDescriptionId, set);
        Bootstrap.checkTranslations(Registry.BLOCK, Block::getDescriptionId, set);
        Bootstrap.checkTranslations(Registry.CUSTOM_STAT, p_135885_ -> "stat." + p_135885_.toString().replace(':', '.'), set);
        Bootstrap.checkGameruleTranslations(set);
        return set;
    }

    public static void checkBootstrapCalled(Supplier<String> p_179913_) {
        if (!isBootstrapped) {
            throw Bootstrap.createBootstrapException(p_179913_);
        }
    }

    private static RuntimeException createBootstrapException(Supplier<String> p_179917_) {
        try {
            String s = p_179917_.get();
            return new IllegalArgumentException("Not bootstrapped (called from " + s + ")");
        }
        catch (Exception exception) {
            IllegalArgumentException runtimeexception = new IllegalArgumentException("Not bootstrapped (failed to resolve location)");
            runtimeexception.addSuppressed(exception);
            return runtimeexception;
        }
    }

    public static void validate() {
        Bootstrap.checkBootstrapCalled(() -> "validate");
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Bootstrap.getMissingTranslations().forEach(p_179915_ -> LOGGER.error("Missing translations: {}", p_179915_));
            Commands.validate();
            Bootstrap.validateThatAllBiomeFeaturesHaveBiomeFilter();
        }
        DefaultAttributes.validate();
    }

    private static void validateThatAllBiomeFeaturesHaveBiomeFilter() {
        BuiltinRegistries.BIOME.stream().forEach(p_197754_ -> {
            List<HolderSet<PlacedFeature>> list = p_197754_.getGenerationSettings().features();
            list.stream().flatMap(HolderSet::stream).forEach(p_206844_ -> {
                if (!((PlacedFeature)p_206844_.value()).placement().contains(BiomeFilter.biome())) {
                    Util.logAndPauseIfInIde("Placed feature " + BuiltinRegistries.PLACED_FEATURE.getResourceKey((PlacedFeature)p_206844_.value()) + " is missing BiomeFilter.biome()");
                }
            });
        });
    }

    private static void wrapStreams() {
        if (LOGGER.isDebugEnabled()) {
            System.setErr(new DebugLoggedPrintStream("STDERR", System.err));
            System.setOut(new DebugLoggedPrintStream("STDOUT", STDOUT));
        } else {
            System.setErr(new LoggedPrintStream("STDERR", System.err));
            System.setOut(new LoggedPrintStream("STDOUT", STDOUT));
        }
    }

    public static void realStdoutPrintln(String pMessage) {
        STDOUT.println(pMessage);
    }
}

