/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ChainedJsonException
extends IOException {
    private final List<Entry> entries = Lists.newArrayList();
    private final String message;

    public ChainedJsonException(String p_135902_) {
        this.entries.add(new Entry());
        this.message = p_135902_;
    }

    public ChainedJsonException(String p_135904_, Throwable p_135905_) {
        super(p_135905_);
        this.entries.add(new Entry());
        this.message = p_135904_;
    }

    public void prependJsonKey(String pKey) {
        this.entries.get(0).addJsonKey(pKey);
    }

    public void setFilenameAndFlush(String pFilename) {
        this.entries.get((int)0).filename = pFilename;
        this.entries.add(0, new Entry());
    }

    @Override
    public String getMessage() {
        return "Invalid " + this.entries.get(this.entries.size() - 1) + ": " + this.message;
    }

    public static ChainedJsonException forException(Exception pException) {
        if (pException instanceof ChainedJsonException) {
            return (ChainedJsonException)pException;
        }
        String s = pException.getMessage();
        if (pException instanceof FileNotFoundException) {
            s = "File not found";
        }
        return new ChainedJsonException(s, pException);
    }

    public static class Entry {
        @Nullable
        String filename;
        private final List<String> jsonKeys = Lists.newArrayList();

        Entry() {
        }

        void addJsonKey(String pKey) {
            this.jsonKeys.add(0, pKey);
        }

        @Nullable
        public String getFilename() {
            return this.filename;
        }

        public String getJsonKeys() {
            return StringUtils.join(this.jsonKeys, (String)"->");
        }

        public String toString() {
            if (this.filename != null) {
                return this.jsonKeys.isEmpty() ? this.filename : String.valueOf(this.filename) + " " + this.getJsonKeys();
            }
            return this.jsonKeys.isEmpty() ? "(Unknown file)" : "(Unknown file) " + this.getJsonKeys();
        }
    }
}

