/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class Main {
    private static final Logger LOGGER = LogUtils.getLogger();

    @DontObfuscate
    public static void main(String[] pArgs) {
        SharedConstants.tryDetectVersion();
        OptionParser optionparser = new OptionParser();
        OptionSpecBuilder optionspec = optionparser.accepts("nogui");
        OptionSpecBuilder optionspec1 = optionparser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder optionspec2 = optionparser.accepts("demo");
        OptionSpecBuilder optionspec3 = optionparser.accepts("bonusChest");
        OptionSpecBuilder optionspec4 = optionparser.accepts("forceUpgrade");
        OptionSpecBuilder optionspec5 = optionparser.accepts("eraseCache");
        OptionSpecBuilder optionspec6 = optionparser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec optionspec7 = optionparser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec12 = optionparser.accepts("serverId").withRequiredArg();
        OptionSpecBuilder optionspec13 = optionparser.accepts("jfrProfile");
        NonOptionArgumentSpec optionspec14 = optionparser.nonOptions();
        try {
            WorldStem worldstem;
            boolean flag;
            OptionSet optionset = optionparser.parse(pArgs);
            if (optionset.has((OptionSpec)optionspec7)) {
                optionparser.printHelpOn((OutputStream)System.err);
                return;
            }
            CrashReport.preload();
            if (optionset.has((OptionSpec)optionspec13)) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            Bootstrap.bootStrap();
            Bootstrap.validate();
            Util.startTimerHackThread();
            Path path = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings dedicatedserversettings = new DedicatedServerSettings(path);
            dedicatedserversettings.forceSave();
            Path path1 = Paths.get("eula.txt", new String[0]);
            Eula eula = new Eula(path1);
            if (optionset.has((OptionSpec)optionspec1)) {
                LOGGER.info("Initialized '{}' and '{}'", (Object)path.toAbsolutePath(), (Object)path1.toAbsolutePath());
                return;
            }
            if (!eula.hasAgreedToEULA()) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File file1 = new File((String)optionset.valueOf((OptionSpec)optionspec9));
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            GameProfileCache gameprofilecache = new GameProfileCache(gameprofilerepository, new File(file1, MinecraftServer.USERID_CACHE_FILE.getName()));
            String s = Optional.ofNullable((String)optionset.valueOf((OptionSpec)optionspec10)).orElse(dedicatedserversettings.getProperties().levelName);
            LevelStorageSource levelstoragesource = LevelStorageSource.createDefault(file1.toPath());
            LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.createAccess(s);
            LevelSummary levelsummary = levelstoragesource$levelstorageaccess.getSummary();
            if (levelsummary != null) {
                if (levelsummary.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!levelsummary.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            }
            if (flag = optionset.has((OptionSpec)optionspec6)) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository packrepository = new PackRepository(PackType.SERVER_DATA, new ServerPacksSource(), new FolderRepositorySource(levelstoragesource$levelstorageaccess.getLevelPath(LevelResource.DATAPACK_DIR).toFile(), PackSource.WORLD));
            try {
                WorldStem.InitConfig worldstem$initconfig = new WorldStem.InitConfig(packrepository, Commands.CommandSelection.DEDICATED, dedicatedserversettings.getProperties().functionPermissionLevel, flag);
                worldstem = WorldStem.load(worldstem$initconfig, () -> {
                    DataPackConfig datapackconfig = levelstoragesource$levelstorageaccess.getDataPacks();
                    return datapackconfig == null ? DataPackConfig.DEFAULT : datapackconfig;
                }, (arg_0, arg_1) -> Main.lambda$1(levelstoragesource$levelstorageaccess, optionset, (OptionSpec)optionspec2, dedicatedserversettings, (OptionSpec)optionspec3, arg_0, arg_1), Util.backgroundExecutor(), Runnable::run).get();
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                packrepository.close();
                return;
            }
            worldstem.updateGlobals();
            RegistryAccess.Frozen registryaccess$frozen = worldstem.registryAccess();
            dedicatedserversettings.getProperties().getWorldGenSettings(registryaccess$frozen);
            WorldData worlddata = worldstem.worldData();
            if (optionset.has((OptionSpec)optionspec4)) {
                Main.forceUpgrade(levelstoragesource$levelstorageaccess, DataFixers.getDataFixer(), optionset.has((OptionSpec)optionspec5), () -> true, worlddata.worldGenSettings());
            }
            levelstoragesource$levelstorageaccess.saveDataTag(registryaccess$frozen, worlddata);
            DedicatedServer dedicatedserver = MinecraftServer.spin(arg_0 -> Main.lambda$4(levelstoragesource$levelstorageaccess, packrepository, worldstem, dedicatedserversettings, minecraftsessionservice, gameprofilerepository, gameprofilecache, optionset, (OptionSpec)optionspec8, (OptionSpec)optionspec11, (OptionSpec)optionspec2, (OptionSpec)optionspec12, (OptionSpec)optionspec, (OptionSpec)optionspec14, arg_0));
            Thread thread = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    dedicatedserver.halt(true);
                }
            };
            thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (Exception exception1) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)exception1);
        }
    }

    private static void forceUpgrade(LevelStorageSource.LevelStorageAccess p_195489_, DataFixer p_195490_, boolean p_195491_, BooleanSupplier p_195492_, WorldGenSettings p_195493_) {
        LOGGER.info("Forcing world upgrade!");
        WorldUpgrader worldupgrader = new WorldUpgrader(p_195489_, p_195490_, p_195493_, p_195491_);
        Component component = null;
        while (!worldupgrader.isFinished()) {
            int i;
            Component component1 = worldupgrader.getStatus();
            if (component != component1) {
                component = component1;
                LOGGER.info(worldupgrader.getStatus().getString());
            }
            if ((i = worldupgrader.getTotalChunks()) > 0) {
                int j = worldupgrader.getConverted() + worldupgrader.getSkipped();
                LOGGER.info("{}% completed ({} / {} chunks)...", new Object[]{Mth.floor((float)j / (float)i * 100.0f), j, i});
            }
            if (!p_195492_.getAsBoolean()) {
                worldupgrader.cancel();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ Pair lambda$1(LevelStorageSource.LevelStorageAccess levelStorageAccess, OptionSet optionSet, OptionSpec optionSpec, DedicatedServerSettings dedicatedServerSettings, OptionSpec optionSpec2, ResourceManager p_206543_, DataPackConfig p_206544_) {
        WorldGenSettings worldgensettings;
        LevelSettings levelsettings;
        RegistryAccess.Writable registryaccess$writable = RegistryAccess.builtinCopy();
        RegistryOps<Tag> dynamicops = RegistryOps.createAndLoad(NbtOps.INSTANCE, registryaccess$writable, p_206543_);
        WorldData worlddata1 = levelStorageAccess.getDataTag(dynamicops, p_206544_, registryaccess$writable.allElementsLifecycle());
        if (worlddata1 != null) {
            return Pair.of((Object)worlddata1, (Object)registryaccess$writable.freeze());
        }
        if (optionSet.has(optionSpec)) {
            levelsettings = MinecraftServer.DEMO_SETTINGS;
            worldgensettings = WorldGenSettings.demoSettings(registryaccess$writable);
        } else {
            DedicatedServerProperties dedicatedserverproperties = dedicatedServerSettings.getProperties();
            levelsettings = new LevelSettings(dedicatedserverproperties.levelName, dedicatedserverproperties.gamemode, dedicatedserverproperties.hardcore, dedicatedserverproperties.difficulty, false, new GameRules(), p_206544_);
            worldgensettings = optionSet.has(optionSpec2) ? dedicatedserverproperties.getWorldGenSettings(registryaccess$writable).withBonusChest() : dedicatedserverproperties.getWorldGenSettings(registryaccess$writable);
        }
        PrimaryLevelData primaryleveldata = new PrimaryLevelData(levelsettings, worldgensettings, Lifecycle.stable());
        return Pair.of((Object)primaryleveldata, (Object)registryaccess$writable.freeze());
    }

    private static /* synthetic */ DedicatedServer lambda$4(LevelStorageSource.LevelStorageAccess levelStorageAccess, PackRepository packRepository, WorldStem worldStem, DedicatedServerSettings dedicatedServerSettings, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, GameProfileCache gameProfileCache, OptionSet optionSet, OptionSpec optionSpec, OptionSpec optionSpec2, OptionSpec optionSpec3, OptionSpec optionSpec4, OptionSpec optionSpec5, OptionSpec optionSpec6, Thread p_206536_) {
        boolean flag1;
        DedicatedServer dedicatedserver1 = new DedicatedServer(p_206536_, levelStorageAccess, packRepository, worldStem, dedicatedServerSettings, DataFixers.getDataFixer(), minecraftSessionService, gameProfileRepository, gameProfileCache, LoggerChunkProgressListener::new);
        dedicatedserver1.setSingleplayerName((String)optionSet.valueOf(optionSpec));
        dedicatedserver1.setPort((Integer)optionSet.valueOf(optionSpec2));
        dedicatedserver1.setDemo(optionSet.has(optionSpec3));
        dedicatedserver1.setId((String)optionSet.valueOf(optionSpec4));
        boolean bl = flag1 = !optionSet.has(optionSpec5) && !optionSet.valuesOf(optionSpec6).contains("nogui");
        if (flag1 && !GraphicsEnvironment.isHeadless()) {
            dedicatedserver1.showGui();
        }
        return dedicatedserver1;
    }
}

