/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ServerFunctionLibrary
implements PreparableReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String FILE_EXTENSION = ".mcfunction";
    private static final int PATH_PREFIX_LENGTH = "functions/".length();
    private static final int PATH_SUFFIX_LENGTH = ".mcfunction".length();
    private volatile Map<ResourceLocation, CommandFunction> functions = ImmutableMap.of();
    private final TagLoader<CommandFunction> tagsLoader = new TagLoader(this::getFunction, "tags/functions");
    private volatile Map<ResourceLocation, Tag<CommandFunction>> tags = Map.of();
    private final int functionCompilationLevel;
    private final CommandDispatcher<CommandSourceStack> dispatcher;

    public Optional<CommandFunction> getFunction(ResourceLocation p_136090_) {
        return Optional.ofNullable(this.functions.get(p_136090_));
    }

    public Map<ResourceLocation, CommandFunction> getFunctions() {
        return this.functions;
    }

    public Tag<CommandFunction> getTag(ResourceLocation p_136098_) {
        return this.tags.getOrDefault(p_136098_, Tag.empty());
    }

    public Iterable<ResourceLocation> getAvailableTags() {
        return this.tags.keySet();
    }

    public ServerFunctionLibrary(int p_136053_, CommandDispatcher<CommandSourceStack> p_136054_) {
        this.functionCompilationLevel = p_136053_;
        this.dispatcher = p_136054_;
    }

    @Override
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier pStage, ResourceManager pResourceManager, ProfilerFiller pPreparationsProfiler, ProfilerFiller pReloadProfiler, Executor pBackgroundExecutor, Executor pGameExecutor) {
        CompletableFuture<Map> completablefuture = CompletableFuture.supplyAsync(() -> this.tagsLoader.load(pResourceManager), pBackgroundExecutor);
        CompletionStage completablefuture1 = CompletableFuture.supplyAsync(() -> pResourceManager.listResources("functions", p_179946_ -> p_179946_.endsWith(FILE_EXTENSION)), pBackgroundExecutor).thenCompose(p_179933_ -> {
            HashMap map = Maps.newHashMap();
            CommandSourceStack commandsourcestack = new CommandSourceStack(CommandSource.NULL, Vec3.ZERO, Vec2.ZERO, null, this.functionCompilationLevel, "", TextComponent.EMPTY, null, null);
            for (ResourceLocation resourcelocation : p_179933_) {
                String s = resourcelocation.getPath();
                ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.getNamespace(), s.substring(PATH_PREFIX_LENGTH, s.length() - PATH_SUFFIX_LENGTH));
                map.put(resourcelocation1, CompletableFuture.supplyAsync(() -> {
                    List<String> list = ServerFunctionLibrary.readLines(pResourceManager, resourcelocation);
                    return CommandFunction.fromLines(resourcelocation1, this.dispatcher, commandsourcestack, list);
                }, pBackgroundExecutor));
            }
            CompletableFuture[] completablefuture2 = map.values().toArray(new CompletableFuture[0]);
            return CompletableFuture.allOf(completablefuture2).handle((p_179949_, p_179950_) -> map);
        });
        return ((CompletableFuture)((CompletableFuture)completablefuture.thenCombine(completablefuture1, Pair::of)).thenCompose(pStage::wait)).thenAcceptAsync(p_179944_ -> {
            Map map = (Map)p_179944_.getSecond();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            map.forEach((p_179941_, p_179942_) -> ((CompletableFuture)p_179942_.handle((p_179954_, p_179955_) -> {
                if (p_179955_ != null) {
                    LOGGER.error("Failed to load function {}", p_179941_, p_179955_);
                } else {
                    builder.put(p_179941_, p_179954_);
                }
                return null;
            })).join());
            this.functions = builder.build();
            this.tags = this.tagsLoader.build((Map)p_179944_.getFirst());
        }, pGameExecutor);
    }

    private static List<String> readLines(ResourceManager p_136070_, ResourceLocation p_136071_) {
        try {
            List list;
            try (Resource resource = p_136070_.getResource(p_136071_);){
                list = IOUtils.readLines((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            }
            return list;
        }
        catch (IOException ioexception) {
            throw new CompletionException(ioexception);
        }
    }
}

