/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardSaveData;

public class ServerScoreboard
extends Scoreboard {
    private final MinecraftServer server;
    private final Set<Objective> trackedObjectives = Sets.newHashSet();
    private final List<Runnable> dirtyListeners = Lists.newArrayList();

    public ServerScoreboard(MinecraftServer p_136197_) {
        this.server = p_136197_;
    }

    @Override
    public void onScoreChanged(Score pScore) {
        super.onScoreChanged(pScore);
        if (this.trackedObjectives.contains(pScore.getObjective())) {
            this.server.getPlayerList().broadcastAll(new ClientboundSetScorePacket(Method.CHANGE, pScore.getObjective().getName(), pScore.getOwner(), pScore.getScore()));
        }
        this.setDirty();
    }

    @Override
    public void onPlayerRemoved(String pScoreName) {
        super.onPlayerRemoved(pScoreName);
        this.server.getPlayerList().broadcastAll(new ClientboundSetScorePacket(Method.REMOVE, null, pScoreName, 0));
        this.setDirty();
    }

    @Override
    public void onPlayerScoreRemoved(String pScoreName, Objective pObjective) {
        super.onPlayerScoreRemoved(pScoreName, pObjective);
        if (this.trackedObjectives.contains(pObjective)) {
            this.server.getPlayerList().broadcastAll(new ClientboundSetScorePacket(Method.REMOVE, pObjective.getName(), pScoreName, 0));
        }
        this.setDirty();
    }

    @Override
    public void setDisplayObjective(int pObjectiveSlot, @Nullable Objective pObjective) {
        Objective objective = this.getDisplayObjective(pObjectiveSlot);
        super.setDisplayObjective(pObjectiveSlot, pObjective);
        if (objective != pObjective && objective != null) {
            if (this.getObjectiveDisplaySlotCount(objective) > 0) {
                this.server.getPlayerList().broadcastAll(new ClientboundSetDisplayObjectivePacket(pObjectiveSlot, pObjective));
            } else {
                this.stopTrackingObjective(objective);
            }
        }
        if (pObjective != null) {
            if (this.trackedObjectives.contains(pObjective)) {
                this.server.getPlayerList().broadcastAll(new ClientboundSetDisplayObjectivePacket(pObjectiveSlot, pObjective));
            } else {
                this.startTrackingObjective(pObjective);
            }
        }
        this.setDirty();
    }

    @Override
    public boolean addPlayerToTeam(String p_136215_, PlayerTeam p_136216_) {
        if (super.addPlayerToTeam(p_136215_, p_136216_)) {
            this.server.getPlayerList().broadcastAll(ClientboundSetPlayerTeamPacket.createPlayerPacket(p_136216_, p_136215_, ClientboundSetPlayerTeamPacket.Action.ADD));
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public void removePlayerFromTeam(String pUsername, PlayerTeam pPlayerTeam) {
        super.removePlayerFromTeam(pUsername, pPlayerTeam);
        this.server.getPlayerList().broadcastAll(ClientboundSetPlayerTeamPacket.createPlayerPacket(pPlayerTeam, pUsername, ClientboundSetPlayerTeamPacket.Action.REMOVE));
        this.setDirty();
    }

    @Override
    public void onObjectiveAdded(Objective pObjective) {
        super.onObjectiveAdded(pObjective);
        this.setDirty();
    }

    @Override
    public void onObjectiveChanged(Objective pObjective) {
        super.onObjectiveChanged(pObjective);
        if (this.trackedObjectives.contains(pObjective)) {
            this.server.getPlayerList().broadcastAll(new ClientboundSetObjectivePacket(pObjective, 2));
        }
        this.setDirty();
    }

    @Override
    public void onObjectiveRemoved(Objective pObjective) {
        super.onObjectiveRemoved(pObjective);
        if (this.trackedObjectives.contains(pObjective)) {
            this.stopTrackingObjective(pObjective);
        }
        this.setDirty();
    }

    @Override
    public void onTeamAdded(PlayerTeam pPlayerTeam) {
        super.onTeamAdded(pPlayerTeam);
        this.server.getPlayerList().broadcastAll(ClientboundSetPlayerTeamPacket.createAddOrModifyPacket(pPlayerTeam, true));
        this.setDirty();
    }

    @Override
    public void onTeamChanged(PlayerTeam pPlayerTeam) {
        super.onTeamChanged(pPlayerTeam);
        this.server.getPlayerList().broadcastAll(ClientboundSetPlayerTeamPacket.createAddOrModifyPacket(pPlayerTeam, false));
        this.setDirty();
    }

    @Override
    public void onTeamRemoved(PlayerTeam pPlayerTeam) {
        super.onTeamRemoved(pPlayerTeam);
        this.server.getPlayerList().broadcastAll(ClientboundSetPlayerTeamPacket.createRemovePacket(pPlayerTeam));
        this.setDirty();
    }

    public void addDirtyListener(Runnable pRunnable) {
        this.dirtyListeners.add(pRunnable);
    }

    protected void setDirty() {
        for (Runnable runnable : this.dirtyListeners) {
            runnable.run();
        }
    }

    public List<Packet<?>> getStartTrackingPackets(Objective pObjective) {
        ArrayList list = Lists.newArrayList();
        list.add(new ClientboundSetObjectivePacket(pObjective, 0));
        int i = 0;
        while (i < 19) {
            if (this.getDisplayObjective(i) == pObjective) {
                list.add(new ClientboundSetDisplayObjectivePacket(i, pObjective));
            }
            ++i;
        }
        for (Score score : this.getPlayerScores(pObjective)) {
            list.add(new ClientboundSetScorePacket(Method.CHANGE, score.getObjective().getName(), score.getOwner(), score.getScore()));
        }
        return list;
    }

    public void startTrackingObjective(Objective pObjective) {
        List<Packet<?>> list = this.getStartTrackingPackets(pObjective);
        for (ServerPlayer serverplayer : this.server.getPlayerList().getPlayers()) {
            for (Packet<?> packet : list) {
                serverplayer.connection.send(packet);
            }
        }
        this.trackedObjectives.add(pObjective);
    }

    public List<Packet<?>> getStopTrackingPackets(Objective p_136234_) {
        ArrayList list = Lists.newArrayList();
        list.add(new ClientboundSetObjectivePacket(p_136234_, 1));
        int i = 0;
        while (i < 19) {
            if (this.getDisplayObjective(i) == p_136234_) {
                list.add(new ClientboundSetDisplayObjectivePacket(i, p_136234_));
            }
            ++i;
        }
        return list;
    }

    public void stopTrackingObjective(Objective p_136236_) {
        List<Packet<?>> list = this.getStopTrackingPackets(p_136236_);
        for (ServerPlayer serverplayer : this.server.getPlayerList().getPlayers()) {
            for (Packet<?> packet : list) {
                serverplayer.connection.send(packet);
            }
        }
        this.trackedObjectives.remove(p_136236_);
    }

    public int getObjectiveDisplaySlotCount(Objective p_136238_) {
        int i = 0;
        int j = 0;
        while (j < 19) {
            if (this.getDisplayObjective(j) == p_136238_) {
                ++i;
            }
            ++j;
        }
        return i;
    }

    public ScoreboardSaveData createData() {
        ScoreboardSaveData scoreboardsavedata = new ScoreboardSaveData(this);
        this.addDirtyListener(scoreboardsavedata::setDirty);
        return scoreboardsavedata;
    }

    public ScoreboardSaveData createData(CompoundTag p_180014_) {
        return this.createData().load(p_180014_);
    }

    public static enum Method {
        CHANGE,
        REMOVE;

    }
}

