/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;

public record WorldStem(CloseableResourceManager resourceManager, ReloadableServerResources dataPackResources, RegistryAccess.Frozen registryAccess, WorldData worldData) implements AutoCloseable
{
    public static CompletableFuture<WorldStem> load(InitConfig p_206912_, DataPackConfigSupplier p_206913_, WorldDataSupplier p_206914_, Executor p_206915_, Executor p_206916_) {
        try {
            DataPackConfig datapackconfig = (DataPackConfig)p_206913_.get();
            DataPackConfig datapackconfig1 = MinecraftServer.configurePackRepository(p_206912_.packRepository(), datapackconfig, p_206912_.safeMode());
            List<PackResources> list = p_206912_.packRepository().openAllSelected();
            MultiPackResourceManager closeableresourcemanager = new MultiPackResourceManager(PackType.SERVER_DATA, list);
            Pair<WorldData, RegistryAccess.Frozen> pair = p_206914_.get(closeableresourcemanager, datapackconfig1);
            WorldData worlddata = (WorldData)pair.getFirst();
            RegistryAccess.Frozen registryaccess$frozen = (RegistryAccess.Frozen)pair.getSecond();
            return ((CompletableFuture)ReloadableServerResources.loadResources(closeableresourcemanager, registryaccess$frozen, p_206912_.commandSelection(), p_206912_.functionCompilationLevel(), p_206915_, p_206916_).whenComplete((p_206909_, p_206910_) -> {
                if (p_206910_ != null) {
                    closeableresourcemanager.close();
                }
            })).thenApply(p_206906_ -> new WorldStem(closeableresourcemanager, (ReloadableServerResources)p_206906_, registryaccess$frozen, worlddata));
        }
        catch (Exception exception) {
            return CompletableFuture.failedFuture(exception);
        }
    }

    @Override
    public void close() {
        this.resourceManager.close();
    }

    public void updateGlobals() {
        this.dataPackResources.updateRegistryTags(this.registryAccess);
    }

    @FunctionalInterface
    public static interface DataPackConfigSupplier
    extends Supplier<DataPackConfig> {
        public static DataPackConfigSupplier loadFromWorld(LevelStorageSource.LevelStorageAccess p_206929_) {
            return () -> {
                DataPackConfig datapackconfig = p_206929_.getDataPacks();
                if (datapackconfig == null) {
                    throw new IllegalStateException("Failed to load data pack config");
                }
                return datapackconfig;
            };
        }
    }

    public record InitConfig(PackRepository packRepository, Commands.CommandSelection commandSelection, int functionCompilationLevel, boolean safeMode) {
    }

    @FunctionalInterface
    public static interface WorldDataSupplier {
        public Pair<WorldData, RegistryAccess.Frozen> get(ResourceManager var1, DataPackConfig var2);

        public static WorldDataSupplier loadFromWorld(LevelStorageSource.LevelStorageAccess p_206955_) {
            return (p_206949_, p_206950_) -> {
                RegistryAccess.Writable registryaccess$writable = RegistryAccess.builtinCopy();
                RegistryOps<Tag> dynamicops = RegistryOps.createAndLoad(NbtOps.INSTANCE, registryaccess$writable, p_206949_);
                WorldData worlddata = p_206955_.getDataTag(dynamicops, p_206950_, registryaccess$writable.allElementsLifecycle());
                if (worlddata == null) {
                    throw new IllegalStateException("Failed to load world");
                }
                return Pair.of((Object)worlddata, (Object)registryaccess$writable.freeze());
            };
        }
    }
}

