/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;

public class AdvancementCommands {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ADVANCEMENTS = (p_136344_, p_136345_) -> {
        Collection<Advancement> collection = ((CommandSourceStack)p_136344_.getSource()).getServer().getAdvancements().getAllAdvancements();
        return SharedSuggestionProvider.suggestResource(collection.stream().map(Advancement::getId), p_136345_);
    };

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("advancement").requires(p_136318_ -> p_136318_.hasPermission(2))).then(Commands.literal("grant").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).then(Commands.literal("only").then(((RequiredArgumentBuilder)Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(p_136363_ -> AdvancementCommands.perform((CommandSourceStack)p_136363_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136363_, "targets"), Action.GRANT, AdvancementCommands.getAdvancements(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136363_, "advancement"), Mode.ONLY)))).then(Commands.argument("criterion", StringArgumentType.greedyString()).suggests((p_136339_, p_136340_) -> SharedSuggestionProvider.suggest(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136339_, "advancement").getCriteria().keySet(), p_136340_)).executes(p_136361_ -> AdvancementCommands.performCriterion((CommandSourceStack)p_136361_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136361_, "targets"), Action.GRANT, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136361_, "advancement"), StringArgumentType.getString((CommandContext)p_136361_, (String)"criterion"))))))).then(Commands.literal("from").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(p_136359_ -> AdvancementCommands.perform((CommandSourceStack)p_136359_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136359_, "targets"), Action.GRANT, AdvancementCommands.getAdvancements(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136359_, "advancement"), Mode.FROM)))))).then(Commands.literal("until").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(p_136357_ -> AdvancementCommands.perform((CommandSourceStack)p_136357_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136357_, "targets"), Action.GRANT, AdvancementCommands.getAdvancements(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136357_, "advancement"), Mode.UNTIL)))))).then(Commands.literal("through").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(p_136355_ -> AdvancementCommands.perform((CommandSourceStack)p_136355_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136355_, "targets"), Action.GRANT, AdvancementCommands.getAdvancements(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136355_, "advancement"), Mode.THROUGH)))))).then(Commands.literal("everything").executes(p_136353_ -> AdvancementCommands.perform((CommandSourceStack)p_136353_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136353_, "targets"), Action.GRANT, ((CommandSourceStack)p_136353_.getSource()).getServer().getAdvancements().getAllAdvancements())))))).then(Commands.literal("revoke").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).then(Commands.literal("only").then(((RequiredArgumentBuilder)Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(p_136351_ -> AdvancementCommands.perform((CommandSourceStack)p_136351_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136351_, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136351_, "advancement"), Mode.ONLY)))).then(Commands.argument("criterion", StringArgumentType.greedyString()).suggests((p_136315_, p_136316_) -> SharedSuggestionProvider.suggest(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136315_, "advancement").getCriteria().keySet(), p_136316_)).executes(p_136349_ -> AdvancementCommands.performCriterion((CommandSourceStack)p_136349_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136349_, "targets"), Action.REVOKE, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136349_, "advancement"), StringArgumentType.getString((CommandContext)p_136349_, (String)"criterion"))))))).then(Commands.literal("from").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(p_136347_ -> AdvancementCommands.perform((CommandSourceStack)p_136347_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136347_, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136347_, "advancement"), Mode.FROM)))))).then(Commands.literal("until").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(p_136342_ -> AdvancementCommands.perform((CommandSourceStack)p_136342_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136342_, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136342_, "advancement"), Mode.UNTIL)))))).then(Commands.literal("through").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(p_136337_ -> AdvancementCommands.perform((CommandSourceStack)p_136337_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136337_, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)p_136337_, "advancement"), Mode.THROUGH)))))).then(Commands.literal("everything").executes(p_136313_ -> AdvancementCommands.perform((CommandSourceStack)p_136313_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136313_, "targets"), Action.REVOKE, ((CommandSourceStack)p_136313_.getSource()).getServer().getAdvancements().getAllAdvancements()))))));
    }

    private static int perform(CommandSourceStack pSource, Collection<ServerPlayer> pTargets, Action pAction, Collection<Advancement> pAdvancements) {
        int i = 0;
        for (ServerPlayer serverplayer : pTargets) {
            i += pAction.perform(serverplayer, pAdvancements);
        }
        if (i == 0) {
            if (pAdvancements.size() == 1) {
                if (pTargets.size() == 1) {
                    throw new CommandRuntimeException(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".one.to.one.failure", pAdvancements.iterator().next().getChatComponent(), pTargets.iterator().next().getDisplayName()));
                }
                throw new CommandRuntimeException(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".one.to.many.failure", pAdvancements.iterator().next().getChatComponent(), pTargets.size()));
            }
            if (pTargets.size() == 1) {
                throw new CommandRuntimeException(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".many.to.one.failure", pAdvancements.size(), pTargets.iterator().next().getDisplayName()));
            }
            throw new CommandRuntimeException(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".many.to.many.failure", pAdvancements.size(), pTargets.size()));
        }
        if (pAdvancements.size() == 1) {
            if (pTargets.size() == 1) {
                pSource.sendSuccess(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".one.to.one.success", pAdvancements.iterator().next().getChatComponent(), pTargets.iterator().next().getDisplayName()), true);
            } else {
                pSource.sendSuccess(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".one.to.many.success", pAdvancements.iterator().next().getChatComponent(), pTargets.size()), true);
            }
        } else if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".many.to.one.success", pAdvancements.size(), pTargets.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".many.to.many.success", pAdvancements.size(), pTargets.size()), true);
        }
        return i;
    }

    private static int performCriterion(CommandSourceStack pSource, Collection<ServerPlayer> pTargets, Action pAction, Advancement pAdvancement, String pCriterionName) {
        int i = 0;
        if (!pAdvancement.getCriteria().containsKey(pCriterionName)) {
            throw new CommandRuntimeException(new TranslatableComponent("commands.advancement.criterionNotFound", pAdvancement.getChatComponent(), pCriterionName));
        }
        for (ServerPlayer serverplayer : pTargets) {
            if (!pAction.performCriterion(serverplayer, pAdvancement, pCriterionName)) continue;
            ++i;
        }
        if (i == 0) {
            if (pTargets.size() == 1) {
                throw new CommandRuntimeException(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".criterion.to.one.failure", pCriterionName, pAdvancement.getChatComponent(), pTargets.iterator().next().getDisplayName()));
            }
            throw new CommandRuntimeException(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".criterion.to.many.failure", pCriterionName, pAdvancement.getChatComponent(), pTargets.size()));
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".criterion.to.one.success", pCriterionName, pAdvancement.getChatComponent(), pTargets.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent(String.valueOf(pAction.getKey()) + ".criterion.to.many.success", pCriterionName, pAdvancement.getChatComponent(), pTargets.size()), true);
        }
        return i;
    }

    private static List<Advancement> getAdvancements(Advancement pAdvancement, Mode pMode) {
        ArrayList list = Lists.newArrayList();
        if (pMode.parents) {
            Advancement advancement = pAdvancement.getParent();
            while (advancement != null) {
                list.add(advancement);
                advancement = advancement.getParent();
            }
        }
        list.add(pAdvancement);
        if (pMode.children) {
            AdvancementCommands.addChildren(pAdvancement, list);
        }
        return list;
    }

    private static void addChildren(Advancement pAdvancement, List<Advancement> pList) {
        for (Advancement advancement : pAdvancement.getChildren()) {
            pList.add(advancement);
            AdvancementCommands.addChildren(advancement, pList);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Action {
        GRANT("grant"){

            @Override
            protected boolean perform(ServerPlayer p_136395_, Advancement p_136396_) {
                AdvancementProgress advancementprogress = p_136395_.getAdvancements().getOrStartProgress(p_136396_);
                if (advancementprogress.isDone()) {
                    return false;
                }
                for (String s : advancementprogress.getRemainingCriteria()) {
                    p_136395_.getAdvancements().award(p_136396_, s);
                }
                return true;
            }

            @Override
            protected boolean performCriterion(ServerPlayer p_136398_, Advancement p_136399_, String p_136400_) {
                return p_136398_.getAdvancements().award(p_136399_, p_136400_);
            }
        }
        ,
        REVOKE("revoke"){

            @Override
            protected boolean perform(ServerPlayer p_136406_, Advancement p_136407_) {
                AdvancementProgress advancementprogress = p_136406_.getAdvancements().getOrStartProgress(p_136407_);
                if (!advancementprogress.hasProgress()) {
                    return false;
                }
                for (String s : advancementprogress.getCompletedCriteria()) {
                    p_136406_.getAdvancements().revoke(p_136407_, s);
                }
                return true;
            }

            @Override
            protected boolean performCriterion(ServerPlayer p_136409_, Advancement p_136410_, String p_136411_) {
                return p_136409_.getAdvancements().revoke(p_136410_, p_136411_);
            }
        };

        private final String key;

        private Action(String p_136372_) {
            this.key = "commands.advancement." + p_136372_;
        }

        public int perform(ServerPlayer pPlayer, Iterable<Advancement> pAdvancements) {
            int i = 0;
            for (Advancement advancement : pAdvancements) {
                if (!this.perform(pPlayer, advancement)) continue;
                ++i;
            }
            return i;
        }

        protected abstract boolean perform(ServerPlayer var1, Advancement var2);

        protected abstract boolean performCriterion(ServerPlayer var1, Advancement var2, String var3);

        protected String getKey() {
            return this.key;
        }
    }

    static enum Mode {
        ONLY(false, false),
        THROUGH(true, true),
        FROM(false, true),
        UNTIL(true, false),
        EVERYTHING(true, true);

        final boolean parents;
        final boolean children;

        private Mode(boolean p_136424_, boolean p_136425_) {
            this.parents = p_136424_;
            this.children = p_136425_;
        }
    }
}

