/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(p_212443_ -> new TranslatableComponent("commands.attribute.failed.entity", p_212443_));
    private static final Dynamic2CommandExceptionType ERROR_NO_SUCH_ATTRIBUTE = new Dynamic2CommandExceptionType((p_212445_, p_212446_) -> new TranslatableComponent("commands.attribute.failed.no_attribute", p_212445_, p_212446_));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((p_212448_, p_212449_, p_212450_) -> new TranslatableComponent("commands.attribute.failed.no_modifier", p_212449_, p_212448_, p_212450_));
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((p_136497_, p_136498_, p_136499_) -> new TranslatableComponent("commands.attribute.failed.modifier_already_present", p_136499_, p_136498_, p_136497_));

    public static void register(CommandDispatcher<CommandSourceStack> p_136445_) {
        p_136445_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("attribute").requires(p_212441_ -> p_212441_.hasPermission(2))).then(Commands.argument("target", EntityArgument.entity()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("attribute", ResourceKeyArgument.key(Registry.ATTRIBUTE_REGISTRY)).then(((LiteralArgumentBuilder)Commands.literal("get").executes(p_212452_ -> AttributeCommand.getAttributeValue((CommandSourceStack)p_212452_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_212452_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_212452_, "attribute"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(p_136522_ -> AttributeCommand.getAttributeValue((CommandSourceStack)p_136522_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_136522_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_136522_, "attribute"), DoubleArgumentType.getDouble((CommandContext)p_136522_, (String)"scale")))))).then(((LiteralArgumentBuilder)Commands.literal("base").then(Commands.literal("set").then(Commands.argument("value", DoubleArgumentType.doubleArg()).executes(p_136520_ -> AttributeCommand.setAttributeBase((CommandSourceStack)p_136520_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_136520_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_136520_, "attribute"), DoubleArgumentType.getDouble((CommandContext)p_136520_, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.literal("get").executes(p_136518_ -> AttributeCommand.getAttributeBase((CommandSourceStack)p_136518_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_136518_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_136518_, "attribute"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(p_136516_ -> AttributeCommand.getAttributeBase((CommandSourceStack)p_136516_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_136516_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_136516_, "attribute"), DoubleArgumentType.getDouble((CommandContext)p_136516_, (String)"scale"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("modifier").then(Commands.literal("add").then(Commands.argument("uuid", UuidArgument.uuid()).then(Commands.argument("name", StringArgumentType.string()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("value", DoubleArgumentType.doubleArg()).then(Commands.literal("add").executes(p_136514_ -> AttributeCommand.addModifier((CommandSourceStack)p_136514_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_136514_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_136514_, "attribute"), UuidArgument.getUuid((CommandContext<CommandSourceStack>)p_136514_, "uuid"), StringArgumentType.getString((CommandContext)p_136514_, (String)"name"), DoubleArgumentType.getDouble((CommandContext)p_136514_, (String)"value"), AttributeModifier.Operation.ADDITION)))).then(Commands.literal("multiply").executes(p_136512_ -> AttributeCommand.addModifier((CommandSourceStack)p_136512_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_136512_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_136512_, "attribute"), UuidArgument.getUuid((CommandContext<CommandSourceStack>)p_136512_, "uuid"), StringArgumentType.getString((CommandContext)p_136512_, (String)"name"), DoubleArgumentType.getDouble((CommandContext)p_136512_, (String)"value"), AttributeModifier.Operation.MULTIPLY_TOTAL)))).then(Commands.literal("multiply_base").executes(p_136510_ -> AttributeCommand.addModifier((CommandSourceStack)p_136510_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_136510_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_136510_, "attribute"), UuidArgument.getUuid((CommandContext<CommandSourceStack>)p_136510_, "uuid"), StringArgumentType.getString((CommandContext)p_136510_, (String)"name"), DoubleArgumentType.getDouble((CommandContext)p_136510_, (String)"value"), AttributeModifier.Operation.MULTIPLY_BASE)))))))).then(Commands.literal("remove").then(Commands.argument("uuid", UuidArgument.uuid()).executes(p_136508_ -> AttributeCommand.removeModifier((CommandSourceStack)p_136508_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_136508_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_136508_, "attribute"), UuidArgument.getUuid((CommandContext<CommandSourceStack>)p_136508_, "uuid")))))).then(Commands.literal("value").then(Commands.literal("get").then(((RequiredArgumentBuilder)Commands.argument("uuid", UuidArgument.uuid()).executes(p_136501_ -> AttributeCommand.getAttributeModifier((CommandSourceStack)p_136501_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_136501_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_136501_, "attribute"), UuidArgument.getUuid((CommandContext<CommandSourceStack>)p_136501_, "uuid"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(p_136490_ -> AttributeCommand.getAttributeModifier((CommandSourceStack)p_136490_.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_136490_, "target"), ResourceKeyArgument.getAttribute((CommandContext<CommandSourceStack>)p_136490_, "attribute"), UuidArgument.getUuid((CommandContext<CommandSourceStack>)p_136490_, "uuid"), DoubleArgumentType.getDouble((CommandContext)p_136490_, (String)"scale")))))))))));
    }

    private static AttributeInstance getAttributeInstance(Entity p_136442_, Attribute p_136443_) throws CommandSyntaxException {
        AttributeInstance attributeinstance = AttributeCommand.getLivingEntity(p_136442_).getAttributes().getInstance(p_136443_);
        if (attributeinstance == null) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)p_136442_.getName(), (Object)new TranslatableComponent(p_136443_.getDescriptionId()));
        }
        return attributeinstance;
    }

    private static LivingEntity getLivingEntity(Entity p_136440_) throws CommandSyntaxException {
        if (!(p_136440_ instanceof LivingEntity)) {
            throw ERROR_NOT_LIVING_ENTITY.create((Object)p_136440_.getName());
        }
        return (LivingEntity)p_136440_;
    }

    private static LivingEntity getEntityWithAttribute(Entity p_136487_, Attribute p_136488_) throws CommandSyntaxException {
        LivingEntity livingentity = AttributeCommand.getLivingEntity(p_136487_);
        if (!livingentity.getAttributes().hasAttribute(p_136488_)) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)p_136487_.getName(), (Object)new TranslatableComponent(p_136488_.getDescriptionId()));
        }
        return livingentity;
    }

    private static int getAttributeValue(CommandSourceStack p_136454_, Entity p_136455_, Attribute p_136456_, double p_136457_) throws CommandSyntaxException {
        LivingEntity livingentity = AttributeCommand.getEntityWithAttribute(p_136455_, p_136456_);
        double d0 = livingentity.getAttributeValue(p_136456_);
        p_136454_.sendSuccess(new TranslatableComponent("commands.attribute.value.get.success", new TranslatableComponent(p_136456_.getDescriptionId()), p_136455_.getName(), d0), false);
        return (int)(d0 * p_136457_);
    }

    private static int getAttributeBase(CommandSourceStack p_136492_, Entity p_136493_, Attribute p_136494_, double p_136495_) throws CommandSyntaxException {
        LivingEntity livingentity = AttributeCommand.getEntityWithAttribute(p_136493_, p_136494_);
        double d0 = livingentity.getAttributeBaseValue(p_136494_);
        p_136492_.sendSuccess(new TranslatableComponent("commands.attribute.base_value.get.success", new TranslatableComponent(p_136494_.getDescriptionId()), p_136493_.getName(), d0), false);
        return (int)(d0 * p_136495_);
    }

    private static int getAttributeModifier(CommandSourceStack p_136464_, Entity p_136465_, Attribute p_136466_, UUID p_136467_, double p_136468_) throws CommandSyntaxException {
        LivingEntity livingentity = AttributeCommand.getEntityWithAttribute(p_136465_, p_136466_);
        AttributeMap attributemap = livingentity.getAttributes();
        if (!attributemap.hasModifier(p_136466_, p_136467_)) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)p_136465_.getName(), (Object)new TranslatableComponent(p_136466_.getDescriptionId()), (Object)p_136467_);
        }
        double d0 = attributemap.getModifierValue(p_136466_, p_136467_);
        p_136464_.sendSuccess(new TranslatableComponent("commands.attribute.modifier.value.get.success", p_136467_, new TranslatableComponent(p_136466_.getDescriptionId()), p_136465_.getName(), d0), false);
        return (int)(d0 * p_136468_);
    }

    private static int setAttributeBase(CommandSourceStack p_136503_, Entity p_136504_, Attribute p_136505_, double p_136506_) throws CommandSyntaxException {
        AttributeCommand.getAttributeInstance(p_136504_, p_136505_).setBaseValue(p_136506_);
        p_136503_.sendSuccess(new TranslatableComponent("commands.attribute.base_value.set.success", new TranslatableComponent(p_136505_.getDescriptionId()), p_136504_.getName(), p_136506_), false);
        return 1;
    }

    private static int addModifier(CommandSourceStack p_136470_, Entity p_136471_, Attribute p_136472_, UUID p_136473_, String p_136474_, double p_136475_, AttributeModifier.Operation p_136476_) throws CommandSyntaxException {
        AttributeModifier attributemodifier;
        AttributeInstance attributeinstance = AttributeCommand.getAttributeInstance(p_136471_, p_136472_);
        if (attributeinstance.hasModifier(attributemodifier = new AttributeModifier(p_136473_, p_136474_, p_136475_, p_136476_))) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)p_136471_.getName(), (Object)new TranslatableComponent(p_136472_.getDescriptionId()), (Object)p_136473_);
        }
        attributeinstance.addPermanentModifier(attributemodifier);
        p_136470_.sendSuccess(new TranslatableComponent("commands.attribute.modifier.add.success", p_136473_, new TranslatableComponent(p_136472_.getDescriptionId()), p_136471_.getName()), false);
        return 1;
    }

    private static int removeModifier(CommandSourceStack p_136459_, Entity p_136460_, Attribute p_136461_, UUID p_136462_) throws CommandSyntaxException {
        AttributeInstance attributeinstance = AttributeCommand.getAttributeInstance(p_136460_, p_136461_);
        if (attributeinstance.removePermanentModifier(p_136462_)) {
            p_136459_.sendSuccess(new TranslatableComponent("commands.attribute.modifier.remove.success", p_136462_, new TranslatableComponent(p_136461_.getDescriptionId()), p_136460_.getName()), false);
            return 1;
        }
        throw ERROR_NO_SUCH_MODIFIER.create((Object)p_136460_.getName(), (Object)new TranslatableComponent(p_136461_.getDescriptionId()), (Object)p_136462_);
    }
}

