/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;

public class BanIpCommands {
    public static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final SimpleCommandExceptionType ERROR_INVALID_IP = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.banip.invalid"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_BANNED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.banip.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("ban-ip").requires(p_136532_ -> p_136532_.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument("target", StringArgumentType.word()).executes(p_136538_ -> BanIpCommands.banIpOrName((CommandSourceStack)p_136538_.getSource(), StringArgumentType.getString((CommandContext)p_136538_, (String)"target"), null))).then(Commands.argument("reason", MessageArgument.message()).executes(p_136530_ -> BanIpCommands.banIpOrName((CommandSourceStack)p_136530_.getSource(), StringArgumentType.getString((CommandContext)p_136530_, (String)"target"), MessageArgument.getMessage((CommandContext<CommandSourceStack>)p_136530_, "reason"))))));
    }

    private static int banIpOrName(CommandSourceStack pSource, String pUsername, @Nullable Component pReason) throws CommandSyntaxException {
        Matcher matcher = IP_ADDRESS_PATTERN.matcher(pUsername);
        if (matcher.matches()) {
            return BanIpCommands.banIp(pSource, pUsername, pReason);
        }
        ServerPlayer serverplayer = pSource.getServer().getPlayerList().getPlayerByName(pUsername);
        if (serverplayer != null) {
            return BanIpCommands.banIp(pSource, serverplayer.getIpAddress(), pReason);
        }
        throw ERROR_INVALID_IP.create();
    }

    private static int banIp(CommandSourceStack pSource, String pIp, @Nullable Component pReason) throws CommandSyntaxException {
        IpBanList ipbanlist = pSource.getServer().getPlayerList().getIpBans();
        if (ipbanlist.isBanned(pIp)) {
            throw ERROR_ALREADY_BANNED.create();
        }
        List<ServerPlayer> list = pSource.getServer().getPlayerList().getPlayersWithAddress(pIp);
        IpBanListEntry ipbanlistentry = new IpBanListEntry(pIp, null, pSource.getTextName(), null, pReason == null ? null : pReason.getString());
        ipbanlist.add(ipbanlistentry);
        pSource.sendSuccess(new TranslatableComponent("commands.banip.success", pIp, ipbanlistentry.getReason()), true);
        if (!list.isEmpty()) {
            pSource.sendSuccess(new TranslatableComponent("commands.banip.info", list.size(), EntitySelector.joinNames(list)), true);
        }
        for (ServerPlayer serverplayer : list) {
            serverplayer.connection.disconnect(new TranslatableComponent("multiplayer.disconnect.ip_banned"));
        }
        return list.size();
    }
}

