/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.player.Player;

public class BossBarCommands {
    private static final DynamicCommandExceptionType ERROR_ALREADY_EXISTS = new DynamicCommandExceptionType(p_136636_ -> new TranslatableComponent("commands.bossbar.create.failed", p_136636_));
    private static final DynamicCommandExceptionType ERROR_DOESNT_EXIST = new DynamicCommandExceptionType(p_136623_ -> new TranslatableComponent("commands.bossbar.unknown", p_136623_));
    private static final SimpleCommandExceptionType ERROR_NO_PLAYER_CHANGE = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.bossbar.set.players.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_NAME_CHANGE = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.bossbar.set.name.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_COLOR_CHANGE = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.bossbar.set.color.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_STYLE_CHANGE = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.bossbar.set.style.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_VALUE_CHANGE = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.bossbar.set.value.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_MAX_CHANGE = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.bossbar.set.max.unchanged"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_HIDDEN = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.bossbar.set.visibility.unchanged.hidden"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_VISIBLE = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.bossbar.set.visibility.unchanged.visible"));
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_BOSS_BAR = (p_136587_, p_136588_) -> SharedSuggestionProvider.suggestResource(((CommandSourceStack)p_136587_.getSource()).getServer().getCustomBossEvents().getIds(), p_136588_);

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("bossbar").requires(p_136627_ -> p_136627_.hasPermission(2))).then(Commands.literal("add").then(Commands.argument("id", ResourceLocationArgument.id()).then(Commands.argument("name", ComponentArgument.textComponent()).executes(p_136693_ -> BossBarCommands.createBar((CommandSourceStack)p_136693_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_136693_, "id"), ComponentArgument.getComponent((CommandContext<CommandSourceStack>)p_136693_, "name"))))))).then(Commands.literal("remove").then(Commands.argument("id", ResourceLocationArgument.id()).suggests(SUGGEST_BOSS_BAR).executes(p_136691_ -> BossBarCommands.removeBar((CommandSourceStack)p_136691_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136691_)))))).then(Commands.literal("list").executes(p_136689_ -> BossBarCommands.listBars((CommandSourceStack)p_136689_.getSource())))).then(Commands.literal("set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests(SUGGEST_BOSS_BAR).then(Commands.literal("name").then(Commands.argument("name", ComponentArgument.textComponent()).executes(p_136687_ -> BossBarCommands.setName((CommandSourceStack)p_136687_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136687_), ComponentArgument.getComponent((CommandContext<CommandSourceStack>)p_136687_, "name")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("color").then(Commands.literal("pink").executes(p_136685_ -> BossBarCommands.setColor((CommandSourceStack)p_136685_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136685_), BossEvent.BossBarColor.PINK)))).then(Commands.literal("blue").executes(p_136683_ -> BossBarCommands.setColor((CommandSourceStack)p_136683_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136683_), BossEvent.BossBarColor.BLUE)))).then(Commands.literal("red").executes(p_136681_ -> BossBarCommands.setColor((CommandSourceStack)p_136681_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136681_), BossEvent.BossBarColor.RED)))).then(Commands.literal("green").executes(p_136679_ -> BossBarCommands.setColor((CommandSourceStack)p_136679_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136679_), BossEvent.BossBarColor.GREEN)))).then(Commands.literal("yellow").executes(p_136677_ -> BossBarCommands.setColor((CommandSourceStack)p_136677_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136677_), BossEvent.BossBarColor.YELLOW)))).then(Commands.literal("purple").executes(p_136675_ -> BossBarCommands.setColor((CommandSourceStack)p_136675_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136675_), BossEvent.BossBarColor.PURPLE)))).then(Commands.literal("white").executes(p_136673_ -> BossBarCommands.setColor((CommandSourceStack)p_136673_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136673_), BossEvent.BossBarColor.WHITE))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("style").then(Commands.literal("progress").executes(p_136671_ -> BossBarCommands.setStyle((CommandSourceStack)p_136671_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136671_), BossEvent.BossBarOverlay.PROGRESS)))).then(Commands.literal("notched_6").executes(p_136669_ -> BossBarCommands.setStyle((CommandSourceStack)p_136669_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136669_), BossEvent.BossBarOverlay.NOTCHED_6)))).then(Commands.literal("notched_10").executes(p_136667_ -> BossBarCommands.setStyle((CommandSourceStack)p_136667_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136667_), BossEvent.BossBarOverlay.NOTCHED_10)))).then(Commands.literal("notched_12").executes(p_136665_ -> BossBarCommands.setStyle((CommandSourceStack)p_136665_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136665_), BossEvent.BossBarOverlay.NOTCHED_12)))).then(Commands.literal("notched_20").executes(p_136663_ -> BossBarCommands.setStyle((CommandSourceStack)p_136663_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136663_), BossEvent.BossBarOverlay.NOTCHED_20))))).then(Commands.literal("value").then(Commands.argument("value", IntegerArgumentType.integer((int)0)).executes(p_136661_ -> BossBarCommands.setValue((CommandSourceStack)p_136661_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136661_), IntegerArgumentType.getInteger((CommandContext)p_136661_, (String)"value")))))).then(Commands.literal("max").then(Commands.argument("max", IntegerArgumentType.integer((int)1)).executes(p_136659_ -> BossBarCommands.setMax((CommandSourceStack)p_136659_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136659_), IntegerArgumentType.getInteger((CommandContext)p_136659_, (String)"max")))))).then(Commands.literal("visible").then(Commands.argument("visible", BoolArgumentType.bool()).executes(p_136657_ -> BossBarCommands.setVisible((CommandSourceStack)p_136657_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136657_), BoolArgumentType.getBool((CommandContext)p_136657_, (String)"visible")))))).then(((LiteralArgumentBuilder)Commands.literal("players").executes(p_136655_ -> BossBarCommands.setPlayers((CommandSourceStack)p_136655_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136655_), Collections.emptyList()))).then(Commands.argument("targets", EntityArgument.players()).executes(p_136653_ -> BossBarCommands.setPlayers((CommandSourceStack)p_136653_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136653_), EntityArgument.getOptionalPlayers((CommandContext<CommandSourceStack>)p_136653_, "targets")))))))).then(Commands.literal("get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests(SUGGEST_BOSS_BAR).then(Commands.literal("value").executes(p_136648_ -> BossBarCommands.getValue((CommandSourceStack)p_136648_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136648_))))).then(Commands.literal("max").executes(p_136643_ -> BossBarCommands.getMax((CommandSourceStack)p_136643_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136643_))))).then(Commands.literal("visible").executes(p_136638_ -> BossBarCommands.getVisible((CommandSourceStack)p_136638_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136638_))))).then(Commands.literal("players").executes(p_136625_ -> BossBarCommands.getPlayers((CommandSourceStack)p_136625_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_136625_)))))));
    }

    private static int getValue(CommandSourceStack pSource, CustomBossEvent pBossbar) {
        pSource.sendSuccess(new TranslatableComponent("commands.bossbar.get.value", pBossbar.getDisplayName(), pBossbar.getValue()), true);
        return pBossbar.getValue();
    }

    private static int getMax(CommandSourceStack pSource, CustomBossEvent pBossbar) {
        pSource.sendSuccess(new TranslatableComponent("commands.bossbar.get.max", pBossbar.getDisplayName(), pBossbar.getMax()), true);
        return pBossbar.getMax();
    }

    private static int getVisible(CommandSourceStack pSource, CustomBossEvent pBossbar) {
        if (pBossbar.isVisible()) {
            pSource.sendSuccess(new TranslatableComponent("commands.bossbar.get.visible.visible", pBossbar.getDisplayName()), true);
            return 1;
        }
        pSource.sendSuccess(new TranslatableComponent("commands.bossbar.get.visible.hidden", pBossbar.getDisplayName()), true);
        return 0;
    }

    private static int getPlayers(CommandSourceStack pSource, CustomBossEvent pBossbar) {
        if (pBossbar.getPlayers().isEmpty()) {
            pSource.sendSuccess(new TranslatableComponent("commands.bossbar.get.players.none", pBossbar.getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.bossbar.get.players.some", pBossbar.getDisplayName(), pBossbar.getPlayers().size(), ComponentUtils.formatList(pBossbar.getPlayers(), Player::getDisplayName)), true);
        }
        return pBossbar.getPlayers().size();
    }

    private static int setVisible(CommandSourceStack pSource, CustomBossEvent pBossbar, boolean pVisible) throws CommandSyntaxException {
        if (pBossbar.isVisible() == pVisible) {
            if (pVisible) {
                throw ERROR_ALREADY_VISIBLE.create();
            }
            throw ERROR_ALREADY_HIDDEN.create();
        }
        pBossbar.setVisible(pVisible);
        if (pVisible) {
            pSource.sendSuccess(new TranslatableComponent("commands.bossbar.set.visible.success.visible", pBossbar.getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.bossbar.set.visible.success.hidden", pBossbar.getDisplayName()), true);
        }
        return 0;
    }

    private static int setValue(CommandSourceStack pSource, CustomBossEvent pBossbar, int pValue) throws CommandSyntaxException {
        if (pBossbar.getValue() == pValue) {
            throw ERROR_NO_VALUE_CHANGE.create();
        }
        pBossbar.setValue(pValue);
        pSource.sendSuccess(new TranslatableComponent("commands.bossbar.set.value.success", pBossbar.getDisplayName(), pValue), true);
        return pValue;
    }

    private static int setMax(CommandSourceStack pSource, CustomBossEvent pBossbar, int pMax) throws CommandSyntaxException {
        if (pBossbar.getMax() == pMax) {
            throw ERROR_NO_MAX_CHANGE.create();
        }
        pBossbar.setMax(pMax);
        pSource.sendSuccess(new TranslatableComponent("commands.bossbar.set.max.success", pBossbar.getDisplayName(), pMax), true);
        return pMax;
    }

    private static int setColor(CommandSourceStack pSource, CustomBossEvent pBossbar, BossEvent.BossBarColor pColor) throws CommandSyntaxException {
        if (pBossbar.getColor().equals((Object)pColor)) {
            throw ERROR_NO_COLOR_CHANGE.create();
        }
        pBossbar.setColor(pColor);
        pSource.sendSuccess(new TranslatableComponent("commands.bossbar.set.color.success", pBossbar.getDisplayName()), true);
        return 0;
    }

    private static int setStyle(CommandSourceStack pSource, CustomBossEvent pBossbar, BossEvent.BossBarOverlay pStyle) throws CommandSyntaxException {
        if (pBossbar.getOverlay().equals((Object)pStyle)) {
            throw ERROR_NO_STYLE_CHANGE.create();
        }
        pBossbar.setOverlay(pStyle);
        pSource.sendSuccess(new TranslatableComponent("commands.bossbar.set.style.success", pBossbar.getDisplayName()), true);
        return 0;
    }

    private static int setName(CommandSourceStack pSource, CustomBossEvent pBossbar, Component pName) throws CommandSyntaxException {
        MutableComponent component = ComponentUtils.updateForEntity(pSource, pName, null, 0);
        if (pBossbar.getName().equals(component)) {
            throw ERROR_NO_NAME_CHANGE.create();
        }
        pBossbar.setName(component);
        pSource.sendSuccess(new TranslatableComponent("commands.bossbar.set.name.success", pBossbar.getDisplayName()), true);
        return 0;
    }

    private static int setPlayers(CommandSourceStack pSource, CustomBossEvent pBossbar, Collection<ServerPlayer> pPlayers) throws CommandSyntaxException {
        boolean flag = pBossbar.setPlayers(pPlayers);
        if (!flag) {
            throw ERROR_NO_PLAYER_CHANGE.create();
        }
        if (pBossbar.getPlayers().isEmpty()) {
            pSource.sendSuccess(new TranslatableComponent("commands.bossbar.set.players.success.none", pBossbar.getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.bossbar.set.players.success.some", pBossbar.getDisplayName(), pPlayers.size(), ComponentUtils.formatList(pPlayers, Player::getDisplayName)), true);
        }
        return pBossbar.getPlayers().size();
    }

    private static int listBars(CommandSourceStack pSource) {
        Collection<CustomBossEvent> collection = pSource.getServer().getCustomBossEvents().getEvents();
        if (collection.isEmpty()) {
            pSource.sendSuccess(new TranslatableComponent("commands.bossbar.list.bars.none"), false);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.bossbar.list.bars.some", collection.size(), ComponentUtils.formatList(collection, CustomBossEvent::getDisplayName)), false);
        }
        return collection.size();
    }

    private static int createBar(CommandSourceStack pSource, ResourceLocation pId, Component pDisplayName) throws CommandSyntaxException {
        CustomBossEvents custombossevents = pSource.getServer().getCustomBossEvents();
        if (custombossevents.get(pId) != null) {
            throw ERROR_ALREADY_EXISTS.create((Object)pId.toString());
        }
        CustomBossEvent custombossevent = custombossevents.create(pId, ComponentUtils.updateForEntity(pSource, pDisplayName, null, 0));
        pSource.sendSuccess(new TranslatableComponent("commands.bossbar.create.success", custombossevent.getDisplayName()), true);
        return custombossevents.getEvents().size();
    }

    private static int removeBar(CommandSourceStack pSource, CustomBossEvent pBossbar) {
        CustomBossEvents custombossevents = pSource.getServer().getCustomBossEvents();
        pBossbar.removeAllPlayers();
        custombossevents.remove(pBossbar);
        pSource.sendSuccess(new TranslatableComponent("commands.bossbar.remove.success", pBossbar.getDisplayName()), true);
        return custombossevents.getEvents().size();
    }

    public static CustomBossEvent getBossBar(CommandContext<CommandSourceStack> pSource) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocationArgument.getId(pSource, "id");
        CustomBossEvent custombossevent = ((CommandSourceStack)pSource.getSource()).getServer().getCustomBossEvents().get(resourcelocation);
        if (custombossevent == null) {
            throw ERROR_DOESNT_EXIST.create((Object)resourcelocation.toString());
        }
        return custombossevent;
    }
}

