/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ClearInventoryCommands {
    private static final DynamicCommandExceptionType ERROR_SINGLE = new DynamicCommandExceptionType(p_136717_ -> new TranslatableComponent("clear.failed.single", p_136717_));
    private static final DynamicCommandExceptionType ERROR_MULTIPLE = new DynamicCommandExceptionType(p_136711_ -> new TranslatableComponent("clear.failed.multiple", p_136711_));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("clear").requires(p_136704_ -> p_136704_.hasPermission(2))).executes(p_136721_ -> ClearInventoryCommands.clearInventory((CommandSourceStack)p_136721_.getSource(), Collections.singleton(((CommandSourceStack)p_136721_.getSource()).getPlayerOrException()), p_180029_ -> true, -1))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(p_136719_ -> ClearInventoryCommands.clearInventory((CommandSourceStack)p_136719_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136719_, "targets"), p_180027_ -> true, -1))).then(((RequiredArgumentBuilder)Commands.argument("item", ItemPredicateArgument.itemPredicate()).executes(p_136715_ -> ClearInventoryCommands.clearInventory((CommandSourceStack)p_136715_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136715_, "targets"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)p_136715_, "item"), -1))).then(Commands.argument("maxCount", IntegerArgumentType.integer((int)0)).executes(p_136702_ -> ClearInventoryCommands.clearInventory((CommandSourceStack)p_136702_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_136702_, "targets"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)p_136702_, "item"), IntegerArgumentType.getInteger((CommandContext)p_136702_, (String)"maxCount")))))));
    }

    private static int clearInventory(CommandSourceStack pSource, Collection<ServerPlayer> pTargetPlayers, Predicate<ItemStack> pItemPredicate, int pMaxCount) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverplayer : pTargetPlayers) {
            i += serverplayer.getInventory().clearOrCountMatchingItems(pItemPredicate, pMaxCount, serverplayer.inventoryMenu.getCraftSlots());
            serverplayer.containerMenu.broadcastChanges();
            serverplayer.inventoryMenu.slotsChanged(serverplayer.getInventory());
        }
        if (i == 0) {
            if (pTargetPlayers.size() == 1) {
                throw ERROR_SINGLE.create((Object)pTargetPlayers.iterator().next().getName());
            }
            throw ERROR_MULTIPLE.create((Object)pTargetPlayers.size());
        }
        if (pMaxCount == 0) {
            if (pTargetPlayers.size() == 1) {
                pSource.sendSuccess(new TranslatableComponent("commands.clear.test.single", i, pTargetPlayers.iterator().next().getDisplayName()), true);
            } else {
                pSource.sendSuccess(new TranslatableComponent("commands.clear.test.multiple", i, pTargetPlayers.size()), true);
            }
        } else if (pTargetPlayers.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.clear.success.single", i, pTargetPlayers.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.clear.success.multiple", i, pTargetPlayers.size()), true);
        }
        return i;
    }
}

