/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;

public class DefaultGameModeCommands {
    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)Commands.literal("defaultgamemode").requires(p_136929_ -> p_136929_.hasPermission(2));
        GameType[] gameTypeArray = GameType.values();
        int n = gameTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameType gametype = gameTypeArray[n2];
            literalargumentbuilder.then(Commands.literal(gametype.getName()).executes(p_136925_ -> DefaultGameModeCommands.setMode((CommandSourceStack)p_136925_.getSource(), gametype)));
            ++n2;
        }
        pDispatcher.register(literalargumentbuilder);
    }

    private static int setMode(CommandSourceStack pCommandSource, GameType pGamemode) {
        int i = 0;
        MinecraftServer minecraftserver = pCommandSource.getServer();
        minecraftserver.setDefaultGameType(pGamemode);
        GameType gametype = minecraftserver.getForcedGameType();
        if (gametype != null) {
            for (ServerPlayer serverplayer : minecraftserver.getPlayerList().getPlayers()) {
                if (!serverplayer.setGameMode(gametype)) continue;
                ++i;
            }
        }
        pCommandSource.sendSuccess(new TranslatableComponent("commands.defaultgamemode.success", pGamemode.getLongDisplayName()), true);
        return i;
    }
}

