/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;

public class DifficultyCommand {
    private static final DynamicCommandExceptionType ERROR_ALREADY_DIFFICULT = new DynamicCommandExceptionType(p_136948_ -> new TranslatableComponent("commands.difficulty.failure", p_136948_));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralArgumentBuilder<CommandSourceStack> literalargumentbuilder = Commands.literal("difficulty");
        Difficulty[] difficultyArray = Difficulty.values();
        int n = difficultyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Difficulty difficulty = difficultyArray[n2];
            literalargumentbuilder.then(Commands.literal(difficulty.getKey()).executes(p_136937_ -> DifficultyCommand.setDifficulty((CommandSourceStack)p_136937_.getSource(), difficulty)));
            ++n2;
        }
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.requires(p_136943_ -> p_136943_.hasPermission(2))).executes(p_136941_ -> {
            Difficulty difficulty1 = ((CommandSourceStack)p_136941_.getSource()).getLevel().getDifficulty();
            ((CommandSourceStack)p_136941_.getSource()).sendSuccess(new TranslatableComponent("commands.difficulty.query", difficulty1.getDisplayName()), false);
            return difficulty1.getId();
        }));
    }

    public static int setDifficulty(CommandSourceStack pSource, Difficulty pDifficulty) throws CommandSyntaxException {
        MinecraftServer minecraftserver = pSource.getServer();
        if (minecraftserver.getWorldData().getDifficulty() == pDifficulty) {
            throw ERROR_ALREADY_DIFFICULT.create((Object)pDifficulty.getKey());
        }
        minecraftserver.setDifficulty(pDifficulty, true);
        pSource.sendSuccess(new TranslatableComponent("commands.difficulty.success", pDifficulty.getDisplayName()), true);
        return 0;
    }
}

