/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MobEffectArgument;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EffectCommands {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.effect.give.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_SPECIFIC_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.effect.clear.specific.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("effect").requires(p_136958_ -> p_136958_.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal("clear").executes(p_136984_ -> EffectCommands.clearEffects((CommandSourceStack)p_136984_.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)p_136984_.getSource()).getEntityOrException())))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).executes(p_136982_ -> EffectCommands.clearEffects((CommandSourceStack)p_136982_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_136982_, "targets")))).then(Commands.argument("effect", MobEffectArgument.effect()).executes(p_136980_ -> EffectCommands.clearEffect((CommandSourceStack)p_136980_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_136980_, "targets"), MobEffectArgument.getEffect((CommandContext<CommandSourceStack>)p_136980_, "effect"))))))).then(Commands.literal("give").then(Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)Commands.argument("effect", MobEffectArgument.effect()).executes(p_136978_ -> EffectCommands.giveEffect((CommandSourceStack)p_136978_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_136978_, "targets"), MobEffectArgument.getEffect((CommandContext<CommandSourceStack>)p_136978_, "effect"), null, 0, true))).then(((RequiredArgumentBuilder)Commands.argument("seconds", IntegerArgumentType.integer((int)1, (int)1000000)).executes(p_136976_ -> EffectCommands.giveEffect((CommandSourceStack)p_136976_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_136976_, "targets"), MobEffectArgument.getEffect((CommandContext<CommandSourceStack>)p_136976_, "effect"), IntegerArgumentType.getInteger((CommandContext)p_136976_, (String)"seconds"), 0, true))).then(((RequiredArgumentBuilder)Commands.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(p_136974_ -> EffectCommands.giveEffect((CommandSourceStack)p_136974_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_136974_, "targets"), MobEffectArgument.getEffect((CommandContext<CommandSourceStack>)p_136974_, "effect"), IntegerArgumentType.getInteger((CommandContext)p_136974_, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)p_136974_, (String)"amplifier"), true))).then(Commands.argument("hideParticles", BoolArgumentType.bool()).executes(p_136956_ -> EffectCommands.giveEffect((CommandSourceStack)p_136956_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_136956_, "targets"), MobEffectArgument.getEffect((CommandContext<CommandSourceStack>)p_136956_, "effect"), IntegerArgumentType.getInteger((CommandContext)p_136956_, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)p_136956_, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)p_136956_, (String)"hideParticles"))))))))));
    }

    private static int giveEffect(CommandSourceStack pSource, Collection<? extends Entity> pTargets, MobEffect pEffect, @Nullable Integer pSeconds, int pAmplifier, boolean pShowParticles) throws CommandSyntaxException {
        int i = 0;
        int j = pSeconds != null ? (pEffect.isInstantenous() ? pSeconds : pSeconds * 20) : (pEffect.isInstantenous() ? 1 : 600);
        for (Entity entity : pTargets) {
            MobEffectInstance mobeffectinstance;
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).addEffect(mobeffectinstance = new MobEffectInstance(pEffect, j, pAmplifier, false, pShowParticles), pSource.getEntity())) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.effect.give.success.single", pEffect.getDisplayName(), pTargets.iterator().next().getDisplayName(), j / 20), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.effect.give.success.multiple", pEffect.getDisplayName(), pTargets.size(), j / 20), true);
        }
        return i;
    }

    private static int clearEffects(CommandSourceStack pSource, Collection<? extends Entity> pTargets) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : pTargets) {
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).removeAllEffects()) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.effect.clear.everything.success.single", pTargets.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.effect.clear.everything.success.multiple", pTargets.size()), true);
        }
        return i;
    }

    private static int clearEffect(CommandSourceStack pSource, Collection<? extends Entity> pTargets, MobEffect pEffect) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : pTargets) {
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).removeEffect(pEffect)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_CLEAR_SPECIFIC_FAILED.create();
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.effect.clear.specific.success.single", pEffect.getDisplayName(), pTargets.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.effect.clear.specific.success.multiple", pEffect.getDisplayName(), pTargets.size()), true);
        }
        return i;
    }
}

