/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ItemEnchantmentArgument;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EnchantCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(p_137029_ -> new TranslatableComponent("commands.enchant.failed.entity", p_137029_));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(p_137027_ -> new TranslatableComponent("commands.enchant.failed.itemless", p_137027_));
    private static final DynamicCommandExceptionType ERROR_INCOMPATIBLE = new DynamicCommandExceptionType(p_137020_ -> new TranslatableComponent("commands.enchant.failed.incompatible", p_137020_));
    private static final Dynamic2CommandExceptionType ERROR_LEVEL_TOO_HIGH = new Dynamic2CommandExceptionType((p_137022_, p_137023_) -> new TranslatableComponent("commands.enchant.failed.level", p_137022_, p_137023_));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.enchant.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("enchant").requires(p_137013_ -> p_137013_.hasPermission(2))).then(Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)Commands.argument("enchantment", ItemEnchantmentArgument.enchantment()).executes(p_137025_ -> EnchantCommand.enchant((CommandSourceStack)p_137025_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_137025_, "targets"), ItemEnchantmentArgument.getEnchantment((CommandContext<CommandSourceStack>)p_137025_, "enchantment"), 1))).then(Commands.argument("level", IntegerArgumentType.integer((int)0)).executes(p_137011_ -> EnchantCommand.enchant((CommandSourceStack)p_137011_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_137011_, "targets"), ItemEnchantmentArgument.getEnchantment((CommandContext<CommandSourceStack>)p_137011_, "enchantment"), IntegerArgumentType.getInteger((CommandContext)p_137011_, (String)"level")))))));
    }

    private static int enchant(CommandSourceStack pSource, Collection<? extends Entity> pTargets, Enchantment pEnchantment, int pLevel) throws CommandSyntaxException {
        if (pLevel > pEnchantment.getMaxLevel()) {
            throw ERROR_LEVEL_TOO_HIGH.create((Object)pLevel, (Object)pEnchantment.getMaxLevel());
        }
        int i = 0;
        for (Entity entity : pTargets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                ItemStack itemstack = livingentity.getMainHandItem();
                if (!itemstack.isEmpty()) {
                    if (pEnchantment.canEnchant(itemstack) && EnchantmentHelper.isEnchantmentCompatible(EnchantmentHelper.getEnchantments(itemstack).keySet(), pEnchantment)) {
                        itemstack.enchant(pEnchantment, pLevel);
                        ++i;
                        continue;
                    }
                    if (pTargets.size() != 1) continue;
                    throw ERROR_INCOMPATIBLE.create((Object)itemstack.getItem().getName(itemstack).getString());
                }
                if (pTargets.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)livingentity.getName().getString());
            }
            if (pTargets.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.getName().getString());
        }
        if (i == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.enchant.success.single", pEnchantment.getFullname(pLevel), pTargets.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.enchant.success.multiple", pEnchantment.getFullname(pLevel), pTargets.size()), true);
        }
        return i;
    }
}

