/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.OptionalInt;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.commands.BossBarCommands;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;

public class ExecuteCommand {
    private static final int MAX_TEST_AREA = 32768;
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((p_137129_, p_137130_) -> new TranslatableComponent("commands.execute.blocks.toobig", p_137129_, p_137130_));
    private static final SimpleCommandExceptionType ERROR_CONDITIONAL_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType ERROR_CONDITIONAL_FAILED_COUNT = new DynamicCommandExceptionType(p_137127_ -> new TranslatableComponent("commands.execute.conditional.fail_count", p_137127_));
    private static final BinaryOperator<ResultConsumer<CommandSourceStack>> CALLBACK_CHAINER = (p_137045_, p_137046_) -> (p_180160_, p_180161_, p_180162_) -> {
        p_137045_.onCommandComplete(p_180160_, p_180161_, p_180162_);
        p_137046_.onCommandComplete(p_180160_, p_180161_, p_180162_);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PREDICATE = (p_137062_, p_137063_) -> {
        PredicateManager predicatemanager = ((CommandSourceStack)p_137062_.getSource()).getServer().getPredicateManager();
        return SharedSuggestionProvider.suggestResource(predicatemanager.getKeys(), p_137063_);
    };

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralCommandNode literalcommandnode = pDispatcher.register((LiteralArgumentBuilder)Commands.literal("execute").requires(p_137197_ -> p_137197_.hasPermission(2)));
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("execute").requires(p_137103_ -> p_137103_.hasPermission(2))).then(Commands.literal("run").redirect((CommandNode)pDispatcher.getRoot()))).then(ExecuteCommand.addConditionals((CommandNode<CommandSourceStack>)literalcommandnode, Commands.literal("if"), true))).then(ExecuteCommand.addConditionals((CommandNode<CommandSourceStack>)literalcommandnode, Commands.literal("unless"), false))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork((CommandNode)literalcommandnode, p_137299_ -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)p_137299_, "targets")) {
                list.add(((CommandSourceStack)p_137299_.getSource()).withEntity(entity));
            }
            return list;
        })))).then(Commands.literal("at").then(Commands.argument("targets", EntityArgument.entities()).fork((CommandNode)literalcommandnode, p_137297_ -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)p_137297_, "targets")) {
                list.add(((CommandSourceStack)p_137297_.getSource()).withLevel((ServerLevel)entity.level).withPosition(entity.position()).withRotation(entity.getRotationVector()));
            }
            return list;
        })))).then(((LiteralArgumentBuilder)Commands.literal("store").then(ExecuteCommand.wrapStores((LiteralCommandNode<CommandSourceStack>)literalcommandnode, Commands.literal("result"), true))).then(ExecuteCommand.wrapStores((LiteralCommandNode<CommandSourceStack>)literalcommandnode, Commands.literal("success"), false)))).then(((LiteralArgumentBuilder)Commands.literal("positioned").then(Commands.argument("pos", Vec3Argument.vec3()).redirect((CommandNode)literalcommandnode, p_137295_ -> ((CommandSourceStack)p_137295_.getSource()).withPosition(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)p_137295_, "pos")).withAnchor(EntityAnchorArgument.Anchor.FEET)))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork((CommandNode)literalcommandnode, p_137293_ -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)p_137293_, "targets")) {
                list.add(((CommandSourceStack)p_137293_.getSource()).withPosition(entity.position()));
            }
            return list;
        }))))).then(((LiteralArgumentBuilder)Commands.literal("rotated").then(Commands.argument("rot", RotationArgument.rotation()).redirect((CommandNode)literalcommandnode, p_137291_ -> ((CommandSourceStack)p_137291_.getSource()).withRotation(RotationArgument.getRotation((CommandContext<CommandSourceStack>)p_137291_, "rot").getRotation((CommandSourceStack)p_137291_.getSource()))))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork((CommandNode)literalcommandnode, p_137289_ -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)p_137289_, "targets")) {
                list.add(((CommandSourceStack)p_137289_.getSource()).withRotation(entity.getRotationVector()));
            }
            return list;
        }))))).then(((LiteralArgumentBuilder)Commands.literal("facing").then(Commands.literal("entity").then(Commands.argument("targets", EntityArgument.entities()).then(Commands.argument("anchor", EntityAnchorArgument.anchor()).fork((CommandNode)literalcommandnode, p_137287_ -> {
            ArrayList list = Lists.newArrayList();
            EntityAnchorArgument.Anchor entityanchorargument$anchor = EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)p_137287_, "anchor");
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)p_137287_, "targets")) {
                list.add(((CommandSourceStack)p_137287_.getSource()).facing(entity, entityanchorargument$anchor));
            }
            return list;
        }))))).then(Commands.argument("pos", Vec3Argument.vec3()).redirect((CommandNode)literalcommandnode, p_137285_ -> ((CommandSourceStack)p_137285_.getSource()).facing(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)p_137285_, "pos")))))).then(Commands.literal("align").then(Commands.argument("axes", SwizzleArgument.swizzle()).redirect((CommandNode)literalcommandnode, p_137283_ -> ((CommandSourceStack)p_137283_.getSource()).withPosition(((CommandSourceStack)p_137283_.getSource()).getPosition().align(SwizzleArgument.getSwizzle((CommandContext<CommandSourceStack>)p_137283_, "axes"))))))).then(Commands.literal("anchored").then(Commands.argument("anchor", EntityAnchorArgument.anchor()).redirect((CommandNode)literalcommandnode, p_137281_ -> ((CommandSourceStack)p_137281_.getSource()).withAnchor(EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)p_137281_, "anchor")))))).then(Commands.literal("in").then(Commands.argument("dimension", DimensionArgument.dimension()).redirect((CommandNode)literalcommandnode, p_137279_ -> ((CommandSourceStack)p_137279_.getSource()).withLevel(DimensionArgument.getDimension((CommandContext<CommandSourceStack>)p_137279_, "dimension"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapStores(LiteralCommandNode<CommandSourceStack> pParent, LiteralArgumentBuilder<CommandSourceStack> pLiteral, boolean pStoringResult) {
        pLiteral.then(Commands.literal("score").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).redirect(pParent, p_137271_ -> ExecuteCommand.storeValue((CommandSourceStack)p_137271_.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)p_137271_, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)p_137271_, "objective"), pStoringResult)))));
        pLiteral.then(Commands.literal("bossbar").then(((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests(BossBarCommands.SUGGEST_BOSS_BAR).then(Commands.literal("value").redirect(pParent, p_137259_ -> ExecuteCommand.storeValue((CommandSourceStack)p_137259_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_137259_), true, pStoringResult)))).then(Commands.literal("max").redirect(pParent, p_137247_ -> ExecuteCommand.storeValue((CommandSourceStack)p_137247_.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)p_137247_), false, pStoringResult)))));
        for (DataCommands.DataProvider datacommands$dataprovider : DataCommands.TARGET_PROVIDERS) {
            datacommands$dataprovider.wrap((ArgumentBuilder<CommandSourceStack, ?>)pLiteral, p_137101_ -> p_137101_.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).then(Commands.literal("int").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)pParent, p_180216_ -> ExecuteCommand.storeData((CommandSourceStack)p_180216_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_180216_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_180216_, "path"), p_180219_ -> IntTag.valueOf((int)((double)p_180219_ * DoubleArgumentType.getDouble((CommandContext)p_180216_, (String)"scale"))), pStoringResult))))).then(Commands.literal("float").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)pParent, p_180209_ -> ExecuteCommand.storeData((CommandSourceStack)p_180209_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_180209_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_180209_, "path"), p_180212_ -> FloatTag.valueOf((float)((double)p_180212_ * DoubleArgumentType.getDouble((CommandContext)p_180209_, (String)"scale"))), pStoringResult))))).then(Commands.literal("short").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)pParent, p_180199_ -> ExecuteCommand.storeData((CommandSourceStack)p_180199_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_180199_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_180199_, "path"), p_180202_ -> ShortTag.valueOf((short)((double)p_180202_ * DoubleArgumentType.getDouble((CommandContext)p_180199_, (String)"scale"))), pStoringResult))))).then(Commands.literal("long").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)pParent, p_180189_ -> ExecuteCommand.storeData((CommandSourceStack)p_180189_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_180189_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_180189_, "path"), p_180192_ -> LongTag.valueOf((long)((double)p_180192_ * DoubleArgumentType.getDouble((CommandContext)p_180189_, (String)"scale"))), pStoringResult))))).then(Commands.literal("double").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)pParent, p_180179_ -> ExecuteCommand.storeData((CommandSourceStack)p_180179_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_180179_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_180179_, "path"), p_180182_ -> DoubleTag.valueOf((double)p_180182_ * DoubleArgumentType.getDouble((CommandContext)p_180179_, (String)"scale")), pStoringResult))))).then(Commands.literal("byte").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)pParent, p_180156_ -> ExecuteCommand.storeData((CommandSourceStack)p_180156_.getSource(), datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_180156_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_180156_, "path"), p_180165_ -> ByteTag.valueOf((byte)((double)p_180165_ * DoubleArgumentType.getDouble((CommandContext)p_180156_, (String)"scale"))), pStoringResult))))));
        }
        return pLiteral;
    }

    private static CommandSourceStack storeValue(CommandSourceStack pSource, Collection<String> pTargets, Objective pObjective, boolean pStoringResult) {
        ServerScoreboard scoreboard = pSource.getServer().getScoreboard();
        return pSource.withCallback((ResultConsumer<CommandSourceStack>)((ResultConsumer)(p_137136_, p_137137_, p_137138_) -> {
            for (String s : pTargets) {
                Score score = scoreboard.getOrCreatePlayerScore(s, pObjective);
                int i = pStoringResult ? p_137138_ : (p_137137_ ? 1 : 0);
                score.setScore(i);
            }
        }), CALLBACK_CHAINER);
    }

    private static CommandSourceStack storeValue(CommandSourceStack pSource, CustomBossEvent pTargets, boolean pObjective, boolean pStoringResult) {
        return pSource.withCallback((ResultConsumer<CommandSourceStack>)((ResultConsumer)(p_137185_, p_137186_, p_137187_) -> {
            int i;
            int n = pStoringResult ? p_137187_ : (i = p_137186_ ? 1 : 0);
            if (pObjective) {
                pTargets.setValue(i);
            } else {
                pTargets.setMax(i);
            }
        }), CALLBACK_CHAINER);
    }

    private static CommandSourceStack storeData(CommandSourceStack pSource, DataAccessor pAccessor, NbtPathArgument.NbtPath pPath, IntFunction<Tag> pTagConverter, boolean pStoringResult) {
        return pSource.withCallback((ResultConsumer<CommandSourceStack>)((ResultConsumer)(p_137153_, p_137154_, p_137155_) -> {
            try {
                CompoundTag compoundtag = pAccessor.getData();
                int i = pStoringResult ? p_137155_ : (p_137154_ ? 1 : 0);
                pPath.set((Tag)compoundtag, () -> (Tag)pTagConverter.apply(i));
                pAccessor.setData(compoundtag);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }), CALLBACK_CHAINER);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addConditionals(CommandNode<CommandSourceStack> pParent, LiteralArgumentBuilder<CommandSourceStack> pLiteral, boolean pIsIf) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)pLiteral.then(Commands.literal("block").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(ExecuteCommand.addConditional(pParent, Commands.argument("block", BlockPredicateArgument.blockPredicate()), pIsIf, p_137277_ -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)p_137277_, "block").test(new BlockInWorld(((CommandSourceStack)p_137277_.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_137277_, "pos"), true))))))).then(Commands.literal("score").then(Commands.argument("target", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targetObjective", ObjectiveArgument.objective()).then(Commands.literal("=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(pParent, Commands.argument("sourceObjective", ObjectiveArgument.objective()), pIsIf, p_137275_ -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)p_137275_, Integer::equals)))))).then(Commands.literal("<").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(pParent, Commands.argument("sourceObjective", ObjectiveArgument.objective()), pIsIf, p_137273_ -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)p_137273_, (Integer p_180204_, Integer p_180205_) -> p_180204_ < p_180205_)))))).then(Commands.literal("<=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(pParent, Commands.argument("sourceObjective", ObjectiveArgument.objective()), pIsIf, p_137261_ -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)p_137261_, (Integer p_180194_, Integer p_180195_) -> p_180194_ <= p_180195_)))))).then(Commands.literal(">").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(pParent, Commands.argument("sourceObjective", ObjectiveArgument.objective()), pIsIf, p_137249_ -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)p_137249_, (Integer p_180184_, Integer p_180185_) -> p_180184_ > p_180185_)))))).then(Commands.literal(">=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(pParent, Commands.argument("sourceObjective", ObjectiveArgument.objective()), pIsIf, p_137234_ -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)p_137234_, (Integer p_180167_, Integer p_180168_) -> p_180167_ >= p_180168_)))))).then(Commands.literal("matches").then(ExecuteCommand.addConditional(pParent, Commands.argument("range", RangeArgument.intRange()), pIsIf, p_137216_ -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)p_137216_, RangeArgument.Ints.getRange((CommandContext<CommandSourceStack>)p_137216_, "range"))))))))).then(Commands.literal("blocks").then(Commands.argument("start", BlockPosArgument.blockPos()).then(Commands.argument("end", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("destination", BlockPosArgument.blockPos()).then(ExecuteCommand.addIfBlocksConditional(pParent, Commands.literal("all"), pIsIf, false))).then(ExecuteCommand.addIfBlocksConditional(pParent, Commands.literal("masked"), pIsIf, true))))))).then(Commands.literal("entity").then(((RequiredArgumentBuilder)Commands.argument("entities", EntityArgument.entities()).fork(pParent, p_137232_ -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)p_137232_, pIsIf, !EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)p_137232_, "entities").isEmpty()))).executes(ExecuteCommand.createNumericConditionalHandler(pIsIf, p_137189_ -> EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)p_137189_, "entities").size()))))).then(Commands.literal("predicate").then(ExecuteCommand.addConditional(pParent, Commands.argument("predicate", ResourceLocationArgument.id()).suggests(SUGGEST_PREDICATE), pIsIf, p_137054_ -> ExecuteCommand.checkCustomPredicate((CommandSourceStack)p_137054_.getSource(), ResourceLocationArgument.getPredicate((CommandContext<CommandSourceStack>)p_137054_, "predicate")))));
        for (DataCommands.DataProvider datacommands$dataprovider : DataCommands.SOURCE_PROVIDERS) {
            pLiteral.then(datacommands$dataprovider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("data"), p_137092_ -> p_137092_.then(((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).fork(pParent, p_180175_ -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)p_180175_, pIsIf, ExecuteCommand.checkMatchingData(datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_180175_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_180175_, "path")) > 0))).executes(ExecuteCommand.createNumericConditionalHandler(pIsIf, p_180152_ -> ExecuteCommand.checkMatchingData(datacommands$dataprovider.access((CommandContext<CommandSourceStack>)p_180152_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_180152_, "path")))))));
        }
        return pLiteral;
    }

    private static Command<CommandSourceStack> createNumericConditionalHandler(boolean p_137167_, CommandNumericPredicate p_137168_) {
        return p_137167_ ? p_137203_ -> {
            int i = p_137168_.test((CommandContext<CommandSourceStack>)p_137203_);
            if (i > 0) {
                ((CommandSourceStack)p_137203_.getSource()).sendSuccess(new TranslatableComponent("commands.execute.conditional.pass_count", i), false);
                return i;
            }
            throw ERROR_CONDITIONAL_FAILED.create();
        } : p_137144_ -> {
            int i = p_137168_.test((CommandContext<CommandSourceStack>)p_137144_);
            if (i == 0) {
                ((CommandSourceStack)p_137144_.getSource()).sendSuccess(new TranslatableComponent("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)i);
        };
    }

    private static int checkMatchingData(DataAccessor p_137146_, NbtPathArgument.NbtPath p_137147_) throws CommandSyntaxException {
        return p_137147_.countMatching(p_137146_.getData());
    }

    private static boolean checkScore(CommandContext<CommandSourceStack> pContext, BiPredicate<Integer, Integer> pComparison) throws CommandSyntaxException {
        String s = ScoreHolderArgument.getName(pContext, "target");
        Objective objective = ObjectiveArgument.getObjective(pContext, "targetObjective");
        String s1 = ScoreHolderArgument.getName(pContext, "source");
        Objective objective1 = ObjectiveArgument.getObjective(pContext, "sourceObjective");
        ServerScoreboard scoreboard = ((CommandSourceStack)pContext.getSource()).getServer().getScoreboard();
        if (scoreboard.hasPlayerScore(s, objective) && scoreboard.hasPlayerScore(s1, objective1)) {
            Score score = scoreboard.getOrCreatePlayerScore(s, objective);
            Score score1 = scoreboard.getOrCreatePlayerScore(s1, objective1);
            return pComparison.test(score.getScore(), score1.getScore());
        }
        return false;
    }

    private static boolean checkScore(CommandContext<CommandSourceStack> pContext, MinMaxBounds.Ints pComparison) throws CommandSyntaxException {
        String s = ScoreHolderArgument.getName(pContext, "target");
        Objective objective = ObjectiveArgument.getObjective(pContext, "targetObjective");
        ServerScoreboard scoreboard = ((CommandSourceStack)pContext.getSource()).getServer().getScoreboard();
        return !scoreboard.hasPlayerScore(s, objective) ? false : pComparison.matches(scoreboard.getOrCreatePlayerScore(s, objective).getScore());
    }

    private static boolean checkCustomPredicate(CommandSourceStack p_137105_, LootItemCondition p_137106_) {
        ServerLevel serverlevel = p_137105_.getLevel();
        LootContext.Builder lootcontext$builder = new LootContext.Builder(serverlevel).withParameter(LootContextParams.ORIGIN, p_137105_.getPosition()).withOptionalParameter(LootContextParams.THIS_ENTITY, p_137105_.getEntity());
        return p_137106_.test(lootcontext$builder.create(LootContextParamSets.COMMAND));
    }

    private static Collection<CommandSourceStack> expect(CommandContext<CommandSourceStack> pContext, boolean pActual, boolean pExpected) {
        return pExpected == pActual ? Collections.singleton((CommandSourceStack)pContext.getSource()) : Collections.emptyList();
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addConditional(CommandNode<CommandSourceStack> pContext, ArgumentBuilder<CommandSourceStack, ?> pBuilder, boolean pValue, CommandPredicate pTest) {
        return pBuilder.fork(pContext, p_137214_ -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)p_137214_, pValue, pTest.test((CommandContext<CommandSourceStack>)p_137214_))).executes(p_137172_ -> {
            if (pValue == pTest.test((CommandContext<CommandSourceStack>)p_137172_)) {
                ((CommandSourceStack)p_137172_.getSource()).sendSuccess(new TranslatableComponent("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED.create();
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addIfBlocksConditional(CommandNode<CommandSourceStack> pParent, ArgumentBuilder<CommandSourceStack, ?> pLiteral, boolean pIsIf, boolean pIsMasked) {
        return pLiteral.fork(pParent, p_137180_ -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)p_137180_, pIsIf, ExecuteCommand.checkRegions((CommandContext<CommandSourceStack>)p_137180_, pIsMasked).isPresent())).executes(pIsIf ? p_137210_ -> ExecuteCommand.checkIfRegions((CommandContext<CommandSourceStack>)p_137210_, pIsMasked) : p_137165_ -> ExecuteCommand.checkUnlessRegions((CommandContext<CommandSourceStack>)p_137165_, pIsMasked));
    }

    private static int checkIfRegions(CommandContext<CommandSourceStack> pContext, boolean pIsMasked) throws CommandSyntaxException {
        OptionalInt optionalint = ExecuteCommand.checkRegions(pContext, pIsMasked);
        if (optionalint.isPresent()) {
            ((CommandSourceStack)pContext.getSource()).sendSuccess(new TranslatableComponent("commands.execute.conditional.pass_count", optionalint.getAsInt()), false);
            return optionalint.getAsInt();
        }
        throw ERROR_CONDITIONAL_FAILED.create();
    }

    private static int checkUnlessRegions(CommandContext<CommandSourceStack> pContext, boolean pIsMasked) throws CommandSyntaxException {
        OptionalInt optionalint = ExecuteCommand.checkRegions(pContext, pIsMasked);
        if (optionalint.isPresent()) {
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)optionalint.getAsInt());
        }
        ((CommandSourceStack)pContext.getSource()).sendSuccess(new TranslatableComponent("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt checkRegions(CommandContext<CommandSourceStack> pContext, boolean pIsMasked) throws CommandSyntaxException {
        return ExecuteCommand.checkRegions(((CommandSourceStack)pContext.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos(pContext, "start"), BlockPosArgument.getLoadedBlockPos(pContext, "end"), BlockPosArgument.getLoadedBlockPos(pContext, "destination"), pIsMasked);
    }

    private static OptionalInt checkRegions(ServerLevel pLevel, BlockPos pBegin, BlockPos pEnd, BlockPos pDestination, boolean pIsMasked) throws CommandSyntaxException {
        BoundingBox boundingbox = BoundingBox.fromCorners(pBegin, pEnd);
        BoundingBox boundingbox1 = BoundingBox.fromCorners(pDestination, pDestination.offset(boundingbox.getLength()));
        BlockPos blockpos = new BlockPos(boundingbox1.minX() - boundingbox.minX(), boundingbox1.minY() - boundingbox.minY(), boundingbox1.minZ() - boundingbox.minZ());
        int i = boundingbox.getXSpan() * boundingbox.getYSpan() * boundingbox.getZSpan();
        if (i > 32768) {
            throw ERROR_AREA_TOO_LARGE.create((Object)32768, (Object)i);
        }
        int j = 0;
        int k = boundingbox.minZ();
        while (k <= boundingbox.maxZ()) {
            int l = boundingbox.minY();
            while (l <= boundingbox.maxY()) {
                int i1 = boundingbox.minX();
                while (i1 <= boundingbox.maxX()) {
                    BlockPos blockpos1 = new BlockPos(i1, l, k);
                    BlockPos blockpos2 = blockpos1.offset(blockpos);
                    BlockState blockstate = pLevel.getBlockState(blockpos1);
                    if (!pIsMasked || !blockstate.is(Blocks.AIR)) {
                        if (blockstate != pLevel.getBlockState(blockpos2)) {
                            return OptionalInt.empty();
                        }
                        BlockEntity blockentity = pLevel.getBlockEntity(blockpos1);
                        BlockEntity blockentity1 = pLevel.getBlockEntity(blockpos2);
                        if (blockentity != null) {
                            CompoundTag compoundtag1;
                            if (blockentity1 == null) {
                                return OptionalInt.empty();
                            }
                            if (blockentity1.getType() != blockentity.getType()) {
                                return OptionalInt.empty();
                            }
                            CompoundTag compoundtag = blockentity.saveWithoutMetadata();
                            if (!compoundtag.equals(compoundtag1 = blockentity1.saveWithoutMetadata())) {
                                return OptionalInt.empty();
                            }
                        }
                        ++j;
                    }
                    ++i1;
                }
                ++l;
            }
            ++k;
        }
        return OptionalInt.of(j);
    }

    @FunctionalInterface
    static interface CommandNumericPredicate {
        public int test(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface CommandPredicate {
        public boolean test(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }
}

