/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class ExperienceCommand {
    private static final SimpleCommandExceptionType ERROR_SET_POINTS_INVALID = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.experience.set.points.invalid"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralCommandNode literalcommandnode = pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("experience").requires(p_137324_ -> p_137324_.hasPermission(2))).then(Commands.literal("add").then(Commands.argument("targets", EntityArgument.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("amount", IntegerArgumentType.integer()).executes(p_137341_ -> ExperienceCommand.addExperience((CommandSourceStack)p_137341_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137341_, "targets"), IntegerArgumentType.getInteger((CommandContext)p_137341_, (String)"amount"), Type.POINTS))).then(Commands.literal("points").executes(p_137339_ -> ExperienceCommand.addExperience((CommandSourceStack)p_137339_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137339_, "targets"), IntegerArgumentType.getInteger((CommandContext)p_137339_, (String)"amount"), Type.POINTS)))).then(Commands.literal("levels").executes(p_137337_ -> ExperienceCommand.addExperience((CommandSourceStack)p_137337_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137337_, "targets"), IntegerArgumentType.getInteger((CommandContext)p_137337_, (String)"amount"), Type.LEVELS))))))).then(Commands.literal("set").then(Commands.argument("targets", EntityArgument.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("amount", IntegerArgumentType.integer((int)0)).executes(p_137335_ -> ExperienceCommand.setExperience((CommandSourceStack)p_137335_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137335_, "targets"), IntegerArgumentType.getInteger((CommandContext)p_137335_, (String)"amount"), Type.POINTS))).then(Commands.literal("points").executes(p_137333_ -> ExperienceCommand.setExperience((CommandSourceStack)p_137333_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137333_, "targets"), IntegerArgumentType.getInteger((CommandContext)p_137333_, (String)"amount"), Type.POINTS)))).then(Commands.literal("levels").executes(p_137331_ -> ExperienceCommand.setExperience((CommandSourceStack)p_137331_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137331_, "targets"), IntegerArgumentType.getInteger((CommandContext)p_137331_, (String)"amount"), Type.LEVELS))))))).then(Commands.literal("query").then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.player()).then(Commands.literal("points").executes(p_137322_ -> ExperienceCommand.queryExperience((CommandSourceStack)p_137322_.getSource(), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)p_137322_, "targets"), Type.POINTS)))).then(Commands.literal("levels").executes(p_137309_ -> ExperienceCommand.queryExperience((CommandSourceStack)p_137309_.getSource(), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)p_137309_, "targets"), Type.LEVELS))))));
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("xp").requires(p_137311_ -> p_137311_.hasPermission(2))).redirect((CommandNode)literalcommandnode));
    }

    private static int queryExperience(CommandSourceStack pSource, ServerPlayer pPlayer, Type pType) {
        int i = pType.query.applyAsInt(pPlayer);
        pSource.sendSuccess(new TranslatableComponent("commands.experience.query." + pType.name, pPlayer.getDisplayName(), i), false);
        return i;
    }

    private static int addExperience(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, int pAmount, Type pType) {
        for (ServerPlayer serverPlayer : pTargets) {
            pType.add.accept(serverPlayer, pAmount);
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.experience.add." + pType.name + ".success.single", pAmount, pTargets.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.experience.add." + pType.name + ".success.multiple", pAmount, pTargets.size()), true);
        }
        return pTargets.size();
    }

    private static int setExperience(CommandSourceStack pSource, Collection<? extends ServerPlayer> pTargets, int pAmount, Type pType) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : pTargets) {
            if (!pType.set.test(serverPlayer, pAmount)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_SET_POINTS_INVALID.create();
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.experience.set." + pType.name + ".success.single", pAmount, pTargets.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.experience.set." + pType.name + ".success.multiple", pAmount, pTargets.size()), true);
        }
        return pTargets.size();
    }

    static enum Type {
        POINTS("points", Player::giveExperiencePoints, (p_137367_, p_137368_) -> {
            if (p_137368_ >= p_137367_.getXpNeededForNextLevel()) {
                return false;
            }
            p_137367_.setExperiencePoints((int)p_137368_);
            return true;
        }, p_137365_ -> Mth.floor(p_137365_.experienceProgress * (float)p_137365_.getXpNeededForNextLevel())),
        LEVELS("levels", ServerPlayer::giveExperienceLevels, (p_137360_, p_137361_) -> {
            p_137360_.setExperienceLevels((int)p_137361_);
            return true;
        }, p_137358_ -> p_137358_.experienceLevel);

        public final BiConsumer<ServerPlayer, Integer> add;
        public final BiPredicate<ServerPlayer, Integer> set;
        public final String name;
        final ToIntFunction<ServerPlayer> query;

        private Type(String p_137353_, BiConsumer<ServerPlayer, Integer> p_137354_, BiPredicate<ServerPlayer, Integer> p_137355_, ToIntFunction<ServerPlayer> p_137356_) {
            this.add = p_137354_;
            this.name = p_137353_;
            this.set = p_137355_;
            this.query = p_137356_;
        }
    }
}

