/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;

public class GameModeCommand {
    public static final int PERMISSION_LEVEL = 2;

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)Commands.literal("gamemode").requires(p_137736_ -> p_137736_.hasPermission(2));
        GameType[] gameTypeArray = GameType.values();
        int n = gameTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameType gametype = gameTypeArray[n2];
            literalargumentbuilder.then(((LiteralArgumentBuilder)Commands.literal(gametype.getName()).executes(p_137743_ -> GameModeCommand.setMode((CommandContext<CommandSourceStack>)p_137743_, Collections.singleton(((CommandSourceStack)p_137743_.getSource()).getPlayerOrException()), gametype))).then(Commands.argument("target", EntityArgument.players()).executes(p_137728_ -> GameModeCommand.setMode((CommandContext<CommandSourceStack>)p_137728_, EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137728_, "target"), gametype))));
            ++n2;
        }
        pDispatcher.register(literalargumentbuilder);
    }

    private static void logGamemodeChange(CommandSourceStack pSource, ServerPlayer pPlayer, GameType pGameType) {
        TranslatableComponent component = new TranslatableComponent("gameMode." + pGameType.getName());
        if (pSource.getEntity() == pPlayer) {
            pSource.sendSuccess(new TranslatableComponent("commands.gamemode.success.self", component), true);
        } else {
            if (pSource.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) {
                pPlayer.sendMessage(new TranslatableComponent("gameMode.changed", component), Util.NIL_UUID);
            }
            pSource.sendSuccess(new TranslatableComponent("commands.gamemode.success.other", pPlayer.getDisplayName(), component), true);
        }
    }

    private static int setMode(CommandContext<CommandSourceStack> pSource, Collection<ServerPlayer> pPlayers, GameType pGameType) {
        int i = 0;
        for (ServerPlayer serverplayer : pPlayers) {
            if (!serverplayer.setGameMode(pGameType)) continue;
            GameModeCommand.logGamemodeChange((CommandSourceStack)pSource.getSource(), serverplayer, pGameType);
            ++i;
        }
        return i;
    }
}

