/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class GiveCommand {
    public static final int MAX_ALLOWED_ITEMSTACKS = 100;

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("give").requires(p_137777_ -> p_137777_.hasPermission(2))).then(Commands.argument("targets", EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument("item", ItemArgument.item()).executes(p_137784_ -> GiveCommand.giveItem((CommandSourceStack)p_137784_.getSource(), ItemArgument.getItem(p_137784_, "item"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137784_, "targets"), 1))).then(Commands.argument("count", IntegerArgumentType.integer((int)1)).executes(p_137775_ -> GiveCommand.giveItem((CommandSourceStack)p_137775_.getSource(), ItemArgument.getItem(p_137775_, "item"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137775_, "targets"), IntegerArgumentType.getInteger((CommandContext)p_137775_, (String)"count")))))));
    }

    private static int giveItem(CommandSourceStack pSource, ItemInput pItem, Collection<ServerPlayer> pTargets, int pCount) throws CommandSyntaxException {
        int i = pItem.getItem().getMaxStackSize();
        int j = i * 100;
        if (pCount > j) {
            pSource.sendFailure(new TranslatableComponent("commands.give.failed.toomanyitems", j, pItem.createItemStack(pCount, false).getDisplayName()));
            return 0;
        }
        for (ServerPlayer serverplayer : pTargets) {
            int k = pCount;
            while (k > 0) {
                int l = Math.min(i, k);
                k -= l;
                ItemStack itemstack = pItem.createItemStack(l, false);
                boolean flag = serverplayer.getInventory().add(itemstack);
                if (flag && itemstack.isEmpty()) {
                    itemstack.setCount(1);
                    ItemEntity itementity1 = serverplayer.drop(itemstack, false);
                    if (itementity1 != null) {
                        itementity1.makeFakeItem();
                    }
                    serverplayer.level.playSound(null, serverplayer.getX(), serverplayer.getY(), serverplayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverplayer.getRandom().nextFloat() - serverplayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    serverplayer.containerMenu.broadcastChanges();
                    continue;
                }
                ItemEntity itementity = serverplayer.drop(itemstack, false);
                if (itementity == null) continue;
                itementity.setNoPickUpDelay();
                itementity.setOwner(serverplayer.getUUID());
            }
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.give.success.single", pCount, pItem.createItemStack(pCount, false).getDisplayName(), pTargets.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.give.success.single", pCount, pItem.createItemStack(pCount, false).getDisplayName(), pTargets.size()), true);
        }
        return pTargets.size();
    }
}

