/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;

public class KillCommand {
    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("kill").requires(p_137812_ -> p_137812_.hasPermission(2))).executes(p_137817_ -> KillCommand.kill((CommandSourceStack)p_137817_.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)p_137817_.getSource()).getEntityOrException())))).then(Commands.argument("targets", EntityArgument.entities()).executes(p_137810_ -> KillCommand.kill((CommandSourceStack)p_137810_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_137810_, "targets")))));
    }

    private static int kill(CommandSourceStack pSource, Collection<? extends Entity> pTargets) {
        for (Entity entity : pTargets) {
            entity.kill();
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.kill.success.single", pTargets.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.kill.success.multiple", pTargets.size()), true);
        }
        return pTargets.size();
    }
}

