/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;

public class LocateCommand {
    private static final DynamicCommandExceptionType ERROR_FAILED = new DynamicCommandExceptionType(p_201831_ -> new TranslatableComponent("commands.locate.failed", p_201831_));
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(p_207534_ -> new TranslatableComponent("commands.locate.invalid", p_207534_));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("locate").requires(p_207513_ -> p_207513_.hasPermission(2))).then(Commands.argument("structure", ResourceOrTagLocationArgument.resourceOrTag(Registry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY)).executes(p_207508_ -> LocateCommand.locate((CommandSourceStack)p_207508_.getSource(), ResourceOrTagLocationArgument.getStructureFeature((CommandContext<CommandSourceStack>)p_207508_, "structure")))));
    }

    private static int locate(CommandSourceStack p_207515_, ResourceOrTagLocationArgument.Result<ConfiguredStructureFeature<?, ?>> p_207516_) throws CommandSyntaxException {
        Registry<ConfiguredStructureFeature<?, ?>> registry = p_207515_.getLevel().registryAccess().registryOrThrow(Registry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
        HolderSet holderset = (HolderSet)((Optional)p_207516_.unwrap().map(p_207532_ -> registry.getHolder((ResourceKey<ConfiguredStructureFeature<?, ?>>)p_207532_).map(p_207529_ -> HolderSet.a(p_207529_)), registry::getTag)).orElseThrow(() -> ERROR_INVALID.create((Object)p_207516_.asPrintable()));
        BlockPos blockpos = new BlockPos(p_207515_.getPosition());
        ServerLevel serverlevel = p_207515_.getLevel();
        Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> pair = serverlevel.getChunkSource().getGenerator().findNearestMapFeature(serverlevel, holderset, blockpos, 100, false);
        if (pair == null) {
            throw ERROR_FAILED.create((Object)p_207516_.asPrintable());
        }
        return LocateCommand.showLocateResult(p_207515_, p_207516_, blockpos, pair, "commands.locate.success");
    }

    public static int showLocateResult(CommandSourceStack p_207518_, ResourceOrTagLocationArgument.Result<?> p_207519_, BlockPos p_207520_, Pair<BlockPos, ? extends Holder<?>> p_207521_, String p_207522_) {
        BlockPos blockpos = (BlockPos)p_207521_.getFirst();
        String s = (String)p_207519_.unwrap().map(p_207538_ -> p_207538_.location().toString(), p_207511_ -> "#" + p_207511_.location() + " (" + ((Holder)p_207521_.getSecond()).unwrapKey().map(p_207536_ -> p_207536_.location().toString()).orElse("[unregistered]") + ")");
        int i = Mth.floor(LocateCommand.dist(p_207520_.getX(), p_207520_.getZ(), blockpos.getX(), blockpos.getZ()));
        MutableComponent component = ComponentUtils.wrapInSquareBrackets(new TranslatableComponent("chat.coordinates", blockpos.getX(), "~", blockpos.getZ())).withStyle(p_207527_ -> p_207527_.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + blockpos.getX() + " ~ " + blockpos.getZ())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new TranslatableComponent("chat.coordinates.tooltip"))));
        p_207518_.sendSuccess(new TranslatableComponent(p_207522_, s, component, i), false);
        return i;
    }

    private static float dist(int pX1, int pZ1, int pX2, int pZ2) {
        int i = pX2 - pX1;
        int j = pZ2 - pZ1;
        return Mth.sqrt(i * i + j * j);
    }
}

