/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class MsgCommand {
    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralCommandNode literalcommandnode = pDispatcher.register((LiteralArgumentBuilder)Commands.literal("msg").then(Commands.argument("targets", EntityArgument.players()).then(Commands.argument("message", MessageArgument.message()).executes(p_138063_ -> MsgCommand.sendMessage((CommandSourceStack)p_138063_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_138063_, "targets"), MessageArgument.getMessage((CommandContext<CommandSourceStack>)p_138063_, "message"))))));
        pDispatcher.register((LiteralArgumentBuilder)Commands.literal("tell").redirect((CommandNode)literalcommandnode));
        pDispatcher.register((LiteralArgumentBuilder)Commands.literal("w").redirect((CommandNode)literalcommandnode));
    }

    private static int sendMessage(CommandSourceStack pSource, Collection<ServerPlayer> pRecipients, Component pMessage) {
        Consumer<Component> consumer;
        UUID uuid = pSource.getEntity() == null ? Util.NIL_UUID : pSource.getEntity().getUUID();
        Entity entity = pSource.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            consumer = p_138059_ -> serverplayer.sendMessage(new TranslatableComponent("commands.message.display.outgoing", p_138059_, pMessage).a(ChatFormatting.GRAY, ChatFormatting.ITALIC), serverplayer.getUUID());
        } else {
            consumer = p_138071_ -> pSource.sendSuccess(new TranslatableComponent("commands.message.display.outgoing", p_138071_, pMessage).a(ChatFormatting.GRAY, ChatFormatting.ITALIC), false);
        }
        for (ServerPlayer serverplayer1 : pRecipients) {
            consumer.accept(serverplayer1.getDisplayName());
            serverplayer1.sendMessage(new TranslatableComponent("commands.message.display.incoming", pSource.getDisplayName(), pMessage).a(ChatFormatting.GRAY, ChatFormatting.ITALIC), uuid);
        }
        return pRecipients.size();
    }
}

