/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.players.UserBanList;

public class PardonCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_BANNED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.pardon.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("pardon").requires(p_138101_ -> p_138101_.hasPermission(3))).then(Commands.argument("targets", GameProfileArgument.gameProfile()).suggests((p_138098_, p_138099_) -> SharedSuggestionProvider.a(((CommandSourceStack)p_138098_.getSource()).getServer().getPlayerList().getBans().getUserList(), p_138099_)).executes(p_138096_ -> PardonCommand.pardonPlayers((CommandSourceStack)p_138096_.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)p_138096_, "targets")))));
    }

    private static int pardonPlayers(CommandSourceStack pSource, Collection<GameProfile> pGameProfiles) throws CommandSyntaxException {
        UserBanList userbanlist = pSource.getServer().getPlayerList().getBans();
        int i = 0;
        for (GameProfile gameprofile : pGameProfiles) {
            if (!userbanlist.isBanned(gameprofile)) continue;
            userbanlist.remove(gameprofile);
            ++i;
            pSource.sendSuccess(new TranslatableComponent("commands.pardon.success", ComponentUtils.getDisplayName(gameprofile)), true);
        }
        if (i == 0) {
            throw ERROR_NOT_BANNED.create();
        }
        return i;
    }
}

