/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.regex.Matcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.commands.BanIpCommands;
import net.minecraft.server.players.IpBanList;

public class PardonIpCommand {
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.pardonip.invalid"));
    private static final SimpleCommandExceptionType ERROR_NOT_BANNED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.pardonip.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("pardon-ip").requires(p_138116_ -> p_138116_.hasPermission(3))).then(Commands.argument("target", StringArgumentType.word()).suggests((p_138113_, p_138114_) -> SharedSuggestionProvider.a(((CommandSourceStack)p_138113_.getSource()).getServer().getPlayerList().getIpBans().getUserList(), p_138114_)).executes(p_138111_ -> PardonIpCommand.unban((CommandSourceStack)p_138111_.getSource(), StringArgumentType.getString((CommandContext)p_138111_, (String)"target")))));
    }

    private static int unban(CommandSourceStack pSource, String pIpAddress) throws CommandSyntaxException {
        Matcher matcher = BanIpCommands.IP_ADDRESS_PATTERN.matcher(pIpAddress);
        if (!matcher.matches()) {
            throw ERROR_INVALID.create();
        }
        IpBanList ipbanlist = pSource.getServer().getPlayerList().getIpBans();
        if (!ipbanlist.isBanned(pIpAddress)) {
            throw ERROR_NOT_BANNED.create();
        }
        ipbanlist.remove(pIpAddress);
        pSource.sendSuccess(new TranslatableComponent("commands.pardonip.success", pIpAddress), true);
        return 1;
    }
}

