/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundCustomSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class PlaySoundCommand {
    private static final SimpleCommandExceptionType ERROR_TOO_FAR = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.playsound.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        RequiredArgumentBuilder requiredargumentbuilder = Commands.argument("sound", ResourceLocationArgument.id()).suggests(SuggestionProviders.AVAILABLE_SOUNDS);
        SoundSource[] soundSourceArray = SoundSource.values();
        int n = soundSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            SoundSource soundsource = soundSourceArray[n2];
            requiredargumentbuilder.then(PlaySoundCommand.source(soundsource));
            ++n2;
        }
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("playsound").requires(p_138159_ -> p_138159_.hasPermission(2))).then((ArgumentBuilder)requiredargumentbuilder));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> source(SoundSource pCategory) {
        return (LiteralArgumentBuilder)Commands.literal(pCategory.getName()).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(p_138180_ -> PlaySoundCommand.playSound((CommandSourceStack)p_138180_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_138180_, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_138180_, "sound"), pCategory, ((CommandSourceStack)p_138180_.getSource()).getPosition(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("pos", Vec3Argument.vec3()).executes(p_138177_ -> PlaySoundCommand.playSound((CommandSourceStack)p_138177_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_138177_, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_138177_, "sound"), pCategory, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)p_138177_, "pos"), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("volume", FloatArgumentType.floatArg((float)0.0f)).executes(p_138174_ -> PlaySoundCommand.playSound((CommandSourceStack)p_138174_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_138174_, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_138174_, "sound"), pCategory, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)p_138174_, "pos"), ((Float)p_138174_.getArgument("volume", Float.class)).floatValue(), 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("pitch", FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(p_138171_ -> PlaySoundCommand.playSound((CommandSourceStack)p_138171_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_138171_, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_138171_, "sound"), pCategory, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)p_138171_, "pos"), ((Float)p_138171_.getArgument("volume", Float.class)).floatValue(), ((Float)p_138171_.getArgument("pitch", Float.class)).floatValue(), 0.0f))).then(Commands.argument("minVolume", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(p_138155_ -> PlaySoundCommand.playSound((CommandSourceStack)p_138155_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_138155_, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_138155_, "sound"), pCategory, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)p_138155_, "pos"), ((Float)p_138155_.getArgument("volume", Float.class)).floatValue(), ((Float)p_138155_.getArgument("pitch", Float.class)).floatValue(), ((Float)p_138155_.getArgument("minVolume", Float.class)).floatValue())))))));
    }

    private static int playSound(CommandSourceStack pSource, Collection<ServerPlayer> pTargets, ResourceLocation pSound, SoundSource pCategory, Vec3 pPos, float pVolume, float pPitch, float pMinVolume) throws CommandSyntaxException {
        double d0 = Math.pow(pVolume > 1.0f ? (double)(pVolume * 16.0f) : 16.0, 2.0);
        int i = 0;
        Iterator<ServerPlayer> iterator = pTargets.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (i == 0) {
                    throw ERROR_TOO_FAR.create();
                }
                if (pTargets.size() == 1) {
                    pSource.sendSuccess(new TranslatableComponent("commands.playsound.success.single", pSound, pTargets.iterator().next().getDisplayName()), true);
                } else {
                    pSource.sendSuccess(new TranslatableComponent("commands.playsound.success.multiple", pSound, pTargets.size()), true);
                }
                return i;
            }
            ServerPlayer serverplayer = iterator.next();
            double d1 = pPos.x - serverplayer.getX();
            double d2 = pPos.y - serverplayer.getY();
            double d3 = pPos.z - serverplayer.getZ();
            double d4 = d1 * d1 + d2 * d2 + d3 * d3;
            Vec3 vec3 = pPos;
            float f = pVolume;
            if (d4 > d0) {
                if (pMinVolume <= 0.0f) continue;
                double d5 = Math.sqrt(d4);
                vec3 = new Vec3(serverplayer.getX() + d1 / d5 * 2.0, serverplayer.getY() + d2 / d5 * 2.0, serverplayer.getZ() + d3 / d5 * 2.0);
                f = pMinVolume;
            }
            serverplayer.connection.send(new ClientboundCustomSoundPacket(pSound, pCategory, vec3, f, pPitch));
            ++i;
        }
    }
}

