/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.HttpUtil;

public class PublishCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.publish.failed"));
    private static final DynamicCommandExceptionType ERROR_ALREADY_PUBLISHED = new DynamicCommandExceptionType(p_138194_ -> new TranslatableComponent("commands.publish.alreadyPublished", p_138194_));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("publish").requires(p_138189_ -> p_138189_.hasPermission(4))).executes(p_138196_ -> PublishCommand.publish((CommandSourceStack)p_138196_.getSource(), HttpUtil.getAvailablePort()))).then(Commands.argument("port", IntegerArgumentType.integer((int)0, (int)65535)).executes(p_138187_ -> PublishCommand.publish((CommandSourceStack)p_138187_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_138187_, (String)"port")))));
    }

    private static int publish(CommandSourceStack pSource, int pPort) throws CommandSyntaxException {
        if (pSource.getServer().isPublished()) {
            throw ERROR_ALREADY_PUBLISHED.create((Object)pSource.getServer().getPort());
        }
        if (!pSource.getServer().publishServer(null, false, pPort)) {
            throw ERROR_FAILED.create();
        }
        pSource.sendSuccess(new TranslatableComponent("commands.publish.success", pPort), true);
        return pPort;
    }
}

