/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;

public class SaveAllCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.save.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("save-all").requires(p_138276_ -> p_138276_.hasPermission(4))).executes(p_138281_ -> SaveAllCommand.saveAll((CommandSourceStack)p_138281_.getSource(), false))).then(Commands.literal("flush").executes(p_138274_ -> SaveAllCommand.saveAll((CommandSourceStack)p_138274_.getSource(), true))));
    }

    private static int saveAll(CommandSourceStack pSource, boolean pFlush) throws CommandSyntaxException {
        pSource.sendSuccess(new TranslatableComponent("commands.save.saving"), false);
        MinecraftServer minecraftserver = pSource.getServer();
        boolean flag = minecraftserver.saveEverything(true, pFlush, true);
        if (!flag) {
            throw ERROR_FAILED.create();
        }
        pSource.sendSuccess(new TranslatableComponent("commands.save.success"), true);
        return 1;
    }
}

