/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;

public class SaveOffCommand {
    private static final SimpleCommandExceptionType ERROR_ALREADY_OFF = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.save.alreadyOff"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("save-off").requires(p_138289_ -> p_138289_.hasPermission(4))).executes(p_138287_ -> {
            CommandSourceStack commandsourcestack = (CommandSourceStack)p_138287_.getSource();
            boolean flag = false;
            for (ServerLevel serverlevel : commandsourcestack.getServer().getAllLevels()) {
                if (serverlevel == null || serverlevel.noSave) continue;
                serverlevel.noSave = true;
                flag = true;
            }
            if (!flag) {
                throw ERROR_ALREADY_OFF.create();
            }
            commandsourcestack.sendSuccess(new TranslatableComponent("commands.save.disabled"), true);
            return 1;
        }));
    }
}

