/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SetBlockCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("setblock").requires(p_138606_ -> p_138606_.hasPermission(2))).then(Commands.argument("pos", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("block", BlockStateArgument.block()).executes(p_138618_ -> SetBlockCommand.setBlock((CommandSourceStack)p_138618_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_138618_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_138618_, "block"), Mode.REPLACE, null))).then(Commands.literal("destroy").executes(p_138616_ -> SetBlockCommand.setBlock((CommandSourceStack)p_138616_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_138616_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_138616_, "block"), Mode.DESTROY, null)))).then(Commands.literal("keep").executes(p_138614_ -> SetBlockCommand.setBlock((CommandSourceStack)p_138614_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_138614_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_138614_, "block"), Mode.REPLACE, p_180517_ -> p_180517_.getLevel().isEmptyBlock(p_180517_.getPos()))))).then(Commands.literal("replace").executes(p_138604_ -> SetBlockCommand.setBlock((CommandSourceStack)p_138604_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_138604_, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_138604_, "block"), Mode.REPLACE, null))))));
    }

    private static int setBlock(CommandSourceStack pSource, BlockPos pPos, BlockInput pState, Mode pMode, @Nullable Predicate<BlockInWorld> pPredicate) throws CommandSyntaxException {
        boolean flag;
        ServerLevel serverlevel = pSource.getLevel();
        if (pPredicate != null && !pPredicate.test(new BlockInWorld(serverlevel, pPos, true))) {
            throw ERROR_FAILED.create();
        }
        if (pMode == Mode.DESTROY) {
            serverlevel.destroyBlock(pPos, true);
            flag = !pState.getState().isAir() || !serverlevel.getBlockState(pPos).isAir();
        } else {
            BlockEntity blockentity = serverlevel.getBlockEntity(pPos);
            Clearable.tryClear(blockentity);
            flag = true;
        }
        if (flag && !pState.place(serverlevel, pPos, 2)) {
            throw ERROR_FAILED.create();
        }
        serverlevel.blockUpdated(pPos, pState.getState().getBlock());
        pSource.sendSuccess(new TranslatableComponent("commands.setblock.success", pPos.getX(), pPos.getY(), pPos.getZ()), true);
        return 1;
    }

    public static interface Filter {
        @Nullable
        public BlockInput filter(BoundingBox var1, BlockPos var2, BlockInput var3, ServerLevel var4);
    }

    public static enum Mode {
        REPLACE,
        DESTROY;

    }
}

