/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.scores.Team;

public class SpreadPlayersCommand {
    private static final int MAX_ITERATION_COUNT = 10000;
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_TEAMS = new Dynamic4CommandExceptionType((p_138745_, p_138746_, p_138747_, p_138748_) -> new TranslatableComponent("commands.spreadplayers.failed.teams", p_138745_, p_138746_, p_138747_, p_138748_));
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_ENTITIES = new Dynamic4CommandExceptionType((p_138723_, p_138724_, p_138725_, p_138726_) -> new TranslatableComponent("commands.spreadplayers.failed.entities", p_138723_, p_138724_, p_138725_, p_138726_));
    private static final Dynamic2CommandExceptionType ERROR_INVALID_MAX_HEIGHT = new Dynamic2CommandExceptionType((p_201854_, p_201855_) -> new TranslatableComponent("commands.spreadplayers.failed.invalid.height", p_201854_, p_201855_));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spreadplayers").requires(p_201852_ -> p_201852_.hasPermission(2))).then(Commands.argument("center", Vec2Argument.vec2()).then(Commands.argument("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)Commands.argument("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(Commands.argument("respectTeams", BoolArgumentType.bool()).then(Commands.argument("targets", EntityArgument.entities()).executes(p_138699_ -> SpreadPlayersCommand.spreadPlayers((CommandSourceStack)p_138699_.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)p_138699_, "center"), FloatArgumentType.getFloat((CommandContext)p_138699_, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)p_138699_, (String)"maxRange"), ((CommandSourceStack)p_138699_.getSource()).getLevel().getMaxBuildHeight(), BoolArgumentType.getBool((CommandContext)p_138699_, (String)"respectTeams"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_138699_, "targets")))))).then(Commands.literal("under").then(Commands.argument("maxHeight", IntegerArgumentType.integer()).then(Commands.argument("respectTeams", BoolArgumentType.bool()).then(Commands.argument("targets", EntityArgument.entities()).executes(p_201850_ -> SpreadPlayersCommand.spreadPlayers((CommandSourceStack)p_201850_.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)p_201850_, "center"), FloatArgumentType.getFloat((CommandContext)p_201850_, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)p_201850_, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)p_201850_, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)p_201850_, (String)"respectTeams"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_201850_, "targets")))))))))));
    }

    private static int spreadPlayers(CommandSourceStack p_138703_, Vec2 p_138704_, float p_138705_, float p_138706_, int p_138707_, boolean p_138708_, Collection<? extends Entity> p_138709_) throws CommandSyntaxException {
        ServerLevel serverlevel = p_138703_.getLevel();
        int i = serverlevel.getMinBuildHeight();
        if (p_138707_ < i) {
            throw ERROR_INVALID_MAX_HEIGHT.create((Object)p_138707_, (Object)i);
        }
        Random random = new Random();
        double d0 = p_138704_.x - p_138706_;
        double d1 = p_138704_.y - p_138706_;
        double d2 = p_138704_.x + p_138706_;
        double d3 = p_138704_.y + p_138706_;
        Position[] aspreadplayerscommand$position = SpreadPlayersCommand.createInitialPositions(random, p_138708_ ? SpreadPlayersCommand.getNumberOfTeams(p_138709_) : p_138709_.size(), d0, d1, d2, d3);
        SpreadPlayersCommand.a(p_138704_, p_138705_, serverlevel, random, d0, d1, d2, d3, p_138707_, aspreadplayerscommand$position, p_138708_);
        double d4 = SpreadPlayersCommand.a(p_138709_, serverlevel, aspreadplayerscommand$position, p_138707_, p_138708_);
        p_138703_.sendSuccess(new TranslatableComponent("commands.spreadplayers.success." + (p_138708_ ? "teams" : "entities"), aspreadplayerscommand$position.length, Float.valueOf(p_138704_.x), Float.valueOf(p_138704_.y), String.format(Locale.ROOT, "%.2f", d4)), true);
        return aspreadplayerscommand$position.length;
    }

    private static int getNumberOfTeams(Collection<? extends Entity> pEntities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : pEntities) {
            if (entity instanceof Player) {
                set.add(entity.getTeam());
                continue;
            }
            set.add(null);
        }
        return set.size();
    }

    private static void a(Vec2 p_138711_, double p_138712_, ServerLevel p_138713_, Random p_138714_, double p_138715_, double p_138716_, double p_138717_, double p_138718_, int p_138719_, Position[] p_138720_, boolean p_138721_) throws CommandSyntaxException {
        boolean flag = true;
        double d0 = 3.4028234663852886E38;
        int i = 0;
        while (i < 10000 && flag) {
            flag = false;
            d0 = 3.4028234663852886E38;
            int j = 0;
            while (j < p_138720_.length) {
                Position spreadplayerscommand$position = p_138720_[j];
                int k = 0;
                Position spreadplayerscommand$position1 = new Position();
                int l = 0;
                while (l < p_138720_.length) {
                    if (j != l) {
                        Position spreadplayerscommand$position2 = p_138720_[l];
                        double d1 = spreadplayerscommand$position.dist(spreadplayerscommand$position2);
                        d0 = Math.min(d1, d0);
                        if (d1 < p_138712_) {
                            ++k;
                            spreadplayerscommand$position1.x += spreadplayerscommand$position2.x - spreadplayerscommand$position.x;
                            spreadplayerscommand$position1.z += spreadplayerscommand$position2.z - spreadplayerscommand$position.z;
                        }
                    }
                    ++l;
                }
                if (k > 0) {
                    spreadplayerscommand$position1.x /= (double)k;
                    spreadplayerscommand$position1.z /= (double)k;
                    double d2 = spreadplayerscommand$position1.getLength();
                    if (d2 > 0.0) {
                        spreadplayerscommand$position1.normalize();
                        spreadplayerscommand$position.moveAway(spreadplayerscommand$position1);
                    } else {
                        spreadplayerscommand$position.randomize(p_138714_, p_138715_, p_138716_, p_138717_, p_138718_);
                    }
                    flag = true;
                }
                if (spreadplayerscommand$position.clamp(p_138715_, p_138716_, p_138717_, p_138718_)) {
                    flag = true;
                }
                ++j;
            }
            if (!flag) {
                Position[] positionArray = p_138720_;
                int n = p_138720_.length;
                int n2 = 0;
                while (n2 < n) {
                    Position spreadplayerscommand$position3 = positionArray[n2];
                    if (!spreadplayerscommand$position3.isSafe(p_138713_, p_138719_)) {
                        spreadplayerscommand$position3.randomize(p_138714_, p_138715_, p_138716_, p_138717_, p_138718_);
                        flag = true;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        if (d0 == 3.4028234663852886E38) {
            d0 = 0.0;
        }
        if (i >= 10000) {
            if (p_138721_) {
                throw ERROR_FAILED_TO_SPREAD_TEAMS.create((Object)p_138720_.length, (Object)Float.valueOf(p_138711_.x), (Object)Float.valueOf(p_138711_.y), (Object)String.format(Locale.ROOT, "%.2f", d0));
            }
            throw ERROR_FAILED_TO_SPREAD_ENTITIES.create((Object)p_138720_.length, (Object)Float.valueOf(p_138711_.x), (Object)Float.valueOf(p_138711_.y), (Object)String.format(Locale.ROOT, "%.2f", d0));
        }
    }

    private static double a(Collection<? extends Entity> p_138730_, ServerLevel p_138731_, Position[] p_138732_, int p_138733_, boolean p_138734_) {
        double d0 = 0.0;
        int i = 0;
        HashMap map = Maps.newHashMap();
        for (Entity entity : p_138730_) {
            Position spreadplayerscommand$position;
            if (p_138734_) {
                Team team;
                Team team2 = team = entity instanceof Player ? entity.getTeam() : null;
                if (!map.containsKey(team)) {
                    map.put(team, p_138732_[i++]);
                }
                spreadplayerscommand$position = (Position)map.get(team);
            } else {
                spreadplayerscommand$position = p_138732_[i++];
            }
            entity.teleportToWithTicket((double)Mth.floor(spreadplayerscommand$position.x) + 0.5, spreadplayerscommand$position.getSpawnY(p_138731_, p_138733_), (double)Mth.floor(spreadplayerscommand$position.z) + 0.5);
            double d2 = Double.MAX_VALUE;
            Position[] positionArray = p_138732_;
            int n = p_138732_.length;
            int n2 = 0;
            while (n2 < n) {
                Position spreadplayerscommand$position1 = positionArray[n2];
                if (spreadplayerscommand$position != spreadplayerscommand$position1) {
                    double d1 = spreadplayerscommand$position.dist(spreadplayerscommand$position1);
                    d2 = Math.min(d1, d2);
                }
                ++n2;
            }
            d0 += d2;
        }
        return p_138730_.size() < 2 ? 0.0 : d0 / (double)p_138730_.size();
    }

    private static Position[] createInitialPositions(Random pRandom, int pCount, double pMinX, double p_138739_, double pMinZ, double p_138741_) {
        Position[] aspreadplayerscommand$position = new Position[pCount];
        int i = 0;
        while (i < aspreadplayerscommand$position.length) {
            Position spreadplayerscommand$position = new Position();
            spreadplayerscommand$position.randomize(pRandom, pMinX, p_138739_, pMinZ, p_138741_);
            aspreadplayerscommand$position[i] = spreadplayerscommand$position;
            ++i;
        }
        return aspreadplayerscommand$position;
    }

    static class Position {
        double x;
        double z;

        Position() {
        }

        double dist(Position pOther) {
            double d0 = this.x - pOther.x;
            double d1 = this.z - pOther.z;
            return Math.sqrt(d0 * d0 + d1 * d1);
        }

        void normalize() {
            double d0 = this.getLength();
            this.x /= d0;
            this.z /= d0;
        }

        double getLength() {
            return Math.sqrt(this.x * this.x + this.z * this.z);
        }

        public void moveAway(Position pOther) {
            this.x -= pOther.x;
            this.z -= pOther.z;
        }

        public boolean clamp(double pMinX, double p_138755_, double pMinZ, double p_138757_) {
            boolean flag = false;
            if (this.x < pMinX) {
                this.x = pMinX;
                flag = true;
            } else if (this.x > pMinZ) {
                this.x = pMinZ;
                flag = true;
            }
            if (this.z < p_138755_) {
                this.z = p_138755_;
                flag = true;
            } else if (this.z > p_138757_) {
                this.z = p_138757_;
                flag = true;
            }
            return flag;
        }

        public int getSpawnY(BlockGetter p_138759_, int p_138760_) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(this.x, (double)(p_138760_ + 1), this.z);
            boolean flag = p_138759_.getBlockState(blockpos$mutableblockpos).isAir();
            blockpos$mutableblockpos.move(Direction.DOWN);
            boolean flag1 = p_138759_.getBlockState(blockpos$mutableblockpos).isAir();
            while (blockpos$mutableblockpos.getY() > p_138759_.getMinBuildHeight()) {
                blockpos$mutableblockpos.move(Direction.DOWN);
                boolean flag2 = p_138759_.getBlockState(blockpos$mutableblockpos).isAir();
                if (!flag2 && flag1 && flag) {
                    return blockpos$mutableblockpos.getY() + 1;
                }
                flag = flag1;
                flag1 = flag2;
            }
            return p_138760_ + 1;
        }

        public boolean isSafe(BlockGetter p_138774_, int p_138775_) {
            BlockPos blockpos = new BlockPos(this.x, (double)(this.getSpawnY(p_138774_, p_138775_) - 1), this.z);
            BlockState blockstate = p_138774_.getBlockState(blockpos);
            Material material = blockstate.getMaterial();
            return blockpos.getY() < p_138775_ && !material.isLiquid() && material != Material.FIRE;
        }

        public void randomize(Random pRandom, double pMinX, double p_138764_, double pMinZ, double p_138766_) {
            this.x = Mth.nextDouble(pRandom, pMinX, pMinZ);
            this.z = Mth.nextDouble(pRandom, p_138764_, p_138766_);
        }
    }
}

