/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;

public class StopSoundCommand {
    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        RequiredArgumentBuilder requiredargumentbuilder = (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(p_138809_ -> StopSoundCommand.stopSound((CommandSourceStack)p_138809_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_138809_, "targets"), null, null))).then(Commands.literal("*").then(Commands.argument("sound", ResourceLocationArgument.id()).suggests(SuggestionProviders.AVAILABLE_SOUNDS).executes(p_138797_ -> StopSoundCommand.stopSound((CommandSourceStack)p_138797_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_138797_, "targets"), null, ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_138797_, "sound")))));
        SoundSource[] soundSourceArray = SoundSource.values();
        int n = soundSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            SoundSource soundsource = soundSourceArray[n2];
            requiredargumentbuilder.then(((LiteralArgumentBuilder)Commands.literal(soundsource.getName()).executes(p_138807_ -> StopSoundCommand.stopSound((CommandSourceStack)p_138807_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_138807_, "targets"), soundsource, null))).then(Commands.argument("sound", ResourceLocationArgument.id()).suggests(SuggestionProviders.AVAILABLE_SOUNDS).executes(p_138793_ -> StopSoundCommand.stopSound((CommandSourceStack)p_138793_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_138793_, "targets"), soundsource, ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_138793_, "sound")))));
            ++n2;
        }
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("stopsound").requires(p_138799_ -> p_138799_.hasPermission(2))).then((ArgumentBuilder)requiredargumentbuilder));
    }

    private static int stopSound(CommandSourceStack pSource, Collection<ServerPlayer> pTargets, @Nullable SoundSource pCategory, @Nullable ResourceLocation pSound) {
        ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(pSound, pCategory);
        for (ServerPlayer serverplayer : pTargets) {
            serverplayer.connection.send(clientboundstopsoundpacket);
        }
        if (pCategory != null) {
            if (pSound != null) {
                pSource.sendSuccess(new TranslatableComponent("commands.stopsound.success.source.sound", pSound, pCategory.getName()), true);
            } else {
                pSource.sendSuccess(new TranslatableComponent("commands.stopsound.success.source.any", pCategory.getName()), true);
            }
        } else if (pSound != null) {
            pSource.sendSuccess(new TranslatableComponent("commands.stopsound.success.sourceless.sound", pSound), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.stopsound.success.sourceless.any"), true);
        }
        return pTargets.size();
    }
}

