/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SummonCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.summon.failed"));
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.summon.invalidPosition"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("summon").requires(p_138819_ -> p_138819_.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument("entity", EntitySummonArgument.id()).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(p_138832_ -> SummonCommand.spawnEntity((CommandSourceStack)p_138832_.getSource(), EntitySummonArgument.getSummonableEntity((CommandContext<CommandSourceStack>)p_138832_, "entity"), ((CommandSourceStack)p_138832_.getSource()).getPosition(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.argument("pos", Vec3Argument.vec3()).executes(p_138830_ -> SummonCommand.spawnEntity((CommandSourceStack)p_138830_.getSource(), EntitySummonArgument.getSummonableEntity((CommandContext<CommandSourceStack>)p_138830_, "entity"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)p_138830_, "pos"), new CompoundTag(), true))).then(Commands.argument("nbt", CompoundTagArgument.compoundTag()).executes(p_138817_ -> SummonCommand.spawnEntity((CommandSourceStack)p_138817_.getSource(), EntitySummonArgument.getSummonableEntity((CommandContext<CommandSourceStack>)p_138817_, "entity"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)p_138817_, "pos"), CompoundTagArgument.getCompoundTag(p_138817_, "nbt"), false))))));
    }

    private static int spawnEntity(CommandSourceStack pSource, ResourceLocation pType, Vec3 pPos, CompoundTag pNbt, boolean pRandomizeProperties) throws CommandSyntaxException {
        BlockPos blockpos = new BlockPos(pPos);
        if (!Level.isInSpawnableBounds(blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag compoundtag = pNbt.copy();
        compoundtag.putString("id", pType.toString());
        ServerLevel serverlevel = pSource.getLevel();
        Entity entity = EntityType.loadEntityRecursive(compoundtag, serverlevel, p_138828_ -> {
            p_138828_.moveTo(vec3.x, vec3.y, vec3.z, p_138828_.getYRot(), p_138828_.getXRot());
            return p_138828_;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (pRandomizeProperties && entity instanceof Mob) {
            ((Mob)entity).finalizeSpawn(pSource.getLevel(), pSource.getLevel().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.COMMAND, null, null);
        }
        if (!serverlevel.tryAddFreshEntityWithPassengers(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        pSource.sendSuccess(new TranslatableComponent("commands.summon.success", entity.getDisplayName()), true);
        return 1;
    }
}

