/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;

public class TagCommand {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.tag.add.failed"));
    private static final SimpleCommandExceptionType ERROR_REMOVE_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.tag.remove.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tag").requires(p_138844_ -> p_138844_.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).then(Commands.literal("add").then(Commands.argument("name", StringArgumentType.word()).executes(p_138861_ -> TagCommand.addTag((CommandSourceStack)p_138861_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_138861_, "targets"), StringArgumentType.getString((CommandContext)p_138861_, (String)"name")))))).then(Commands.literal("remove").then(Commands.argument("name", StringArgumentType.word()).suggests((p_138841_, p_138842_) -> SharedSuggestionProvider.suggest(TagCommand.getTags(EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_138841_, "targets")), p_138842_)).executes(p_138855_ -> TagCommand.removeTag((CommandSourceStack)p_138855_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_138855_, "targets"), StringArgumentType.getString((CommandContext)p_138855_, (String)"name")))))).then(Commands.literal("list").executes(p_138839_ -> TagCommand.listTags((CommandSourceStack)p_138839_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_138839_, "targets"))))));
    }

    private static Collection<String> getTags(Collection<? extends Entity> pEntities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : pEntities) {
            set.addAll(entity.getTags());
        }
        return set;
    }

    private static int addTag(CommandSourceStack pSource, Collection<? extends Entity> pEntities, String pTagName) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : pEntities) {
            if (!entity.addTag(pTagName)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_ADD_FAILED.create();
        }
        if (pEntities.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.tag.add.success.single", pTagName, pEntities.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.tag.add.success.multiple", pTagName, pEntities.size()), true);
        }
        return i;
    }

    private static int removeTag(CommandSourceStack pSource, Collection<? extends Entity> pEntities, String pTagName) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : pEntities) {
            if (!entity.removeTag(pTagName)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_REMOVE_FAILED.create();
        }
        if (pEntities.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.tag.remove.success.single", pTagName, pEntities.iterator().next().getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.tag.remove.success.multiple", pTagName, pEntities.size()), true);
        }
        return i;
    }

    private static int listTags(CommandSourceStack pSource, Collection<? extends Entity> pEntities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : pEntities) {
            set.addAll(entity.getTags());
        }
        if (pEntities.size() == 1) {
            Entity entity = pEntities.iterator().next();
            if (set.isEmpty()) {
                pSource.sendSuccess(new TranslatableComponent("commands.tag.list.single.empty", entity.getDisplayName()), false);
            } else {
                pSource.sendSuccess(new TranslatableComponent("commands.tag.list.single.success", entity.getDisplayName(), set.size(), ComponentUtils.formatList(set)), false);
            }
        } else if (set.isEmpty()) {
            pSource.sendSuccess(new TranslatableComponent("commands.tag.list.multiple.empty", pEntities.size()), false);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.tag.list.multiple.success", pEntities.size(), set.size(), ComponentUtils.formatList(set)), false);
        }
        return set.size();
    }
}

