/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class TeleportCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.teleport.invalidPosition"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralCommandNode literalcommandnode = pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("teleport").requires(p_139039_ -> p_139039_.hasPermission(2))).then(Commands.argument("location", Vec3Argument.vec3()).executes(p_139051_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139051_.getSource(), Collections.singleton(((CommandSourceStack)p_139051_.getSource()).getEntityOrException()), ((CommandSourceStack)p_139051_.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)p_139051_, "location"), WorldCoordinates.current(), null)))).then(Commands.argument("destination", EntityArgument.entity()).executes(p_139049_ -> TeleportCommand.teleportToEntity((CommandSourceStack)p_139049_.getSource(), Collections.singleton(((CommandSourceStack)p_139049_.getSource()).getEntityOrException()), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_139049_, "destination"))))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("location", Vec3Argument.vec3()).executes(p_139047_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139047_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_139047_, "targets"), ((CommandSourceStack)p_139047_.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)p_139047_, "location"), null, null))).then(Commands.argument("rotation", RotationArgument.rotation()).executes(p_139045_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139045_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_139045_, "targets"), ((CommandSourceStack)p_139045_.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)p_139045_, "location"), RotationArgument.getRotation((CommandContext<CommandSourceStack>)p_139045_, "rotation"), null)))).then(((LiteralArgumentBuilder)Commands.literal("facing").then(Commands.literal("entity").then(((RequiredArgumentBuilder)Commands.argument("facingEntity", EntityArgument.entity()).executes(p_139043_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139043_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_139043_, "targets"), ((CommandSourceStack)p_139043_.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)p_139043_, "location"), null, new LookAt(EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_139043_, "facingEntity"), EntityAnchorArgument.Anchor.FEET)))).then(Commands.argument("facingAnchor", EntityAnchorArgument.anchor()).executes(p_139041_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139041_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_139041_, "targets"), ((CommandSourceStack)p_139041_.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)p_139041_, "location"), null, new LookAt(EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_139041_, "facingEntity"), EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)p_139041_, "facingAnchor")))))))).then(Commands.argument("facingLocation", Vec3Argument.vec3()).executes(p_139037_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139037_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_139037_, "targets"), ((CommandSourceStack)p_139037_.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)p_139037_, "location"), null, new LookAt(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)p_139037_, "facingLocation")))))))).then(Commands.argument("destination", EntityArgument.entity()).executes(p_139011_ -> TeleportCommand.teleportToEntity((CommandSourceStack)p_139011_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_139011_, "targets"), EntityArgument.getEntity((CommandContext<CommandSourceStack>)p_139011_, "destination"))))));
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tp").requires(p_139013_ -> p_139013_.hasPermission(2))).redirect((CommandNode)literalcommandnode));
    }

    private static int teleportToEntity(CommandSourceStack pSource, Collection<? extends Entity> pTargets, Entity pDestination) throws CommandSyntaxException {
        for (Entity entity : pTargets) {
            TeleportCommand.performTeleport(pSource, entity, (ServerLevel)pDestination.level, pDestination.getX(), pDestination.getY(), pDestination.getZ(), EnumSet.noneOf(ClientboundPlayerPositionPacket.RelativeArgument.class), pDestination.getYRot(), pDestination.getXRot(), null);
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.teleport.success.entity.single", pTargets.iterator().next().getDisplayName(), pDestination.getDisplayName()), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.teleport.success.entity.multiple", pTargets.size(), pDestination.getDisplayName()), true);
        }
        return pTargets.size();
    }

    private static int teleportToPos(CommandSourceStack pSource, Collection<? extends Entity> pTargets, ServerLevel pLevel, Coordinates pPosition, @Nullable Coordinates pRotation, @Nullable LookAt pFacing) throws CommandSyntaxException {
        Vec3 vec3 = pPosition.getPosition(pSource);
        Vec2 vec2 = pRotation == null ? null : pRotation.getRotation(pSource);
        EnumSet<ClientboundPlayerPositionPacket.RelativeArgument> set = EnumSet.noneOf(ClientboundPlayerPositionPacket.RelativeArgument.class);
        if (pPosition.isXRelative()) {
            set.add(ClientboundPlayerPositionPacket.RelativeArgument.X);
        }
        if (pPosition.isYRelative()) {
            set.add(ClientboundPlayerPositionPacket.RelativeArgument.Y);
        }
        if (pPosition.isZRelative()) {
            set.add(ClientboundPlayerPositionPacket.RelativeArgument.Z);
        }
        if (pRotation == null) {
            set.add(ClientboundPlayerPositionPacket.RelativeArgument.X_ROT);
            set.add(ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT);
        } else {
            if (pRotation.isXRelative()) {
                set.add(ClientboundPlayerPositionPacket.RelativeArgument.X_ROT);
            }
            if (pRotation.isYRelative()) {
                set.add(ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT);
            }
        }
        for (Entity entity : pTargets) {
            if (pRotation == null) {
                TeleportCommand.performTeleport(pSource, entity, pLevel, vec3.x, vec3.y, vec3.z, set, entity.getYRot(), entity.getXRot(), pFacing);
                continue;
            }
            TeleportCommand.performTeleport(pSource, entity, pLevel, vec3.x, vec3.y, vec3.z, set, vec2.y, vec2.x, pFacing);
        }
        if (pTargets.size() == 1) {
            pSource.sendSuccess(new TranslatableComponent("commands.teleport.success.location.single", pTargets.iterator().next().getDisplayName(), TeleportCommand.formatDouble(vec3.x), TeleportCommand.formatDouble(vec3.y), TeleportCommand.formatDouble(vec3.z)), true);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.teleport.success.location.multiple", pTargets.size(), TeleportCommand.formatDouble(vec3.x), TeleportCommand.formatDouble(vec3.y), TeleportCommand.formatDouble(vec3.z)), true);
        }
        return pTargets.size();
    }

    private static String formatDouble(double p_142776_) {
        return String.format(Locale.ROOT, "%f", p_142776_);
    }

    private static void performTeleport(CommandSourceStack pSource, Entity pEntity, ServerLevel pLevel, double pX, double p_139019_, double pY, Set<ClientboundPlayerPositionPacket.RelativeArgument> p_139021_, float pZ, float p_139023_, @Nullable LookAt pRelativeList) throws CommandSyntaxException {
        BlockPos blockpos = new BlockPos(pX, p_139019_, pY);
        if (!Level.isInSpawnableBounds(blockpos)) {
            throw INVALID_POSITION.create();
        }
        float f = Mth.wrapDegrees(pZ);
        float f1 = Mth.wrapDegrees(p_139023_);
        if (pEntity instanceof ServerPlayer) {
            ChunkPos chunkpos = new ChunkPos(new BlockPos(pX, p_139019_, pY));
            pLevel.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 1, pEntity.getId());
            pEntity.stopRiding();
            if (((ServerPlayer)pEntity).isSleeping()) {
                ((ServerPlayer)pEntity).stopSleepInBed(true, true);
            }
            if (pLevel == pEntity.level) {
                ((ServerPlayer)pEntity).connection.teleport(pX, p_139019_, pY, f, f1, p_139021_);
            } else {
                ((ServerPlayer)pEntity).teleportTo(pLevel, pX, p_139019_, pY, f, f1);
            }
            pEntity.setYHeadRot(f);
        } else {
            float f2 = Mth.clamp(f1, -90.0f, 90.0f);
            if (pLevel == pEntity.level) {
                pEntity.moveTo(pX, p_139019_, pY, f, f2);
                pEntity.setYHeadRot(f);
            } else {
                pEntity.unRide();
                Entity entity = pEntity;
                pEntity = pEntity.getType().create(pLevel);
                if (pEntity == null) {
                    return;
                }
                pEntity.restoreFrom(entity);
                pEntity.moveTo(pX, p_139019_, pY, f, f2);
                pEntity.setYHeadRot(f);
                entity.setRemoved(Entity.RemovalReason.CHANGED_DIMENSION);
                pLevel.addDuringTeleport(pEntity);
            }
        }
        if (pRelativeList != null) {
            pRelativeList.perform(pSource, pEntity);
        }
        if (!(pEntity instanceof LivingEntity) || !((LivingEntity)pEntity).isFallFlying()) {
            pEntity.setDeltaMovement(pEntity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            pEntity.setOnGround(true);
        }
        if (pEntity instanceof PathfinderMob) {
            ((PathfinderMob)pEntity).getNavigation().stop();
        }
    }

    static class LookAt {
        private final Vec3 position;
        private final Entity entity;
        private final EntityAnchorArgument.Anchor anchor;

        public LookAt(Entity p_139056_, EntityAnchorArgument.Anchor p_139057_) {
            this.entity = p_139056_;
            this.anchor = p_139057_;
            this.position = p_139057_.apply(p_139056_);
        }

        public LookAt(Vec3 p_139059_) {
            this.entity = null;
            this.position = p_139059_;
            this.anchor = null;
        }

        public void perform(CommandSourceStack pSource, Entity pEntity) {
            if (this.entity != null) {
                if (pEntity instanceof ServerPlayer) {
                    ((ServerPlayer)pEntity).lookAt(pSource.getAnchor(), this.entity, this.anchor);
                } else {
                    pEntity.lookAt(pSource.getAnchor(), this.position);
                }
            } else {
                pEntity.lookAt(pSource.getAnchor(), this.position);
            }
        }
    }
}

