/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;

public class TimeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("time").requires(p_139076_ -> p_139076_.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("set").then(Commands.literal("day").executes(p_139101_ -> TimeCommand.setTime((CommandSourceStack)p_139101_.getSource(), 1000)))).then(Commands.literal("noon").executes(p_139099_ -> TimeCommand.setTime((CommandSourceStack)p_139099_.getSource(), 6000)))).then(Commands.literal("night").executes(p_139097_ -> TimeCommand.setTime((CommandSourceStack)p_139097_.getSource(), 13000)))).then(Commands.literal("midnight").executes(p_139095_ -> TimeCommand.setTime((CommandSourceStack)p_139095_.getSource(), 18000)))).then(Commands.argument("time", TimeArgument.time()).executes(p_139093_ -> TimeCommand.setTime((CommandSourceStack)p_139093_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_139093_, (String)"time")))))).then(Commands.literal("add").then(Commands.argument("time", TimeArgument.time()).executes(p_139091_ -> TimeCommand.addTime((CommandSourceStack)p_139091_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_139091_, (String)"time")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("query").then(Commands.literal("daytime").executes(p_139086_ -> TimeCommand.queryTime((CommandSourceStack)p_139086_.getSource(), TimeCommand.getDayTime(((CommandSourceStack)p_139086_.getSource()).getLevel()))))).then(Commands.literal("gametime").executes(p_139081_ -> TimeCommand.queryTime((CommandSourceStack)p_139081_.getSource(), (int)(((CommandSourceStack)p_139081_.getSource()).getLevel().getGameTime() % Integer.MAX_VALUE))))).then(Commands.literal("day").executes(p_139074_ -> TimeCommand.queryTime((CommandSourceStack)p_139074_.getSource(), (int)(((CommandSourceStack)p_139074_.getSource()).getLevel().getDayTime() / 24000L % Integer.MAX_VALUE))))));
    }

    private static int getDayTime(ServerLevel pLevel) {
        return (int)(pLevel.getDayTime() % 24000L);
    }

    private static int queryTime(CommandSourceStack pSource, int pTime) {
        pSource.sendSuccess(new TranslatableComponent("commands.time.query", pTime), false);
        return pTime;
    }

    public static int setTime(CommandSourceStack pSource, int pTime) {
        for (ServerLevel serverlevel : pSource.getServer().getAllLevels()) {
            serverlevel.setDayTime(pTime);
        }
        pSource.sendSuccess(new TranslatableComponent("commands.time.set", pTime), true);
        return TimeCommand.getDayTime(pSource.getLevel());
    }

    public static int addTime(CommandSourceStack pSource, int pAmount) {
        for (ServerLevel serverlevel : pSource.getServer().getAllLevels()) {
            serverlevel.setDayTime(serverlevel.getDayTime() + (long)pAmount);
        }
        int i = TimeCommand.getDayTime(pSource.getLevel());
        pSource.sendSuccess(new TranslatableComponent("commands.time.set", i), true);
        return i;
    }
}

