/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class TriggerCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_PRIMED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.trigger.failed.unprimed"));
    private static final SimpleCommandExceptionType ERROR_INVALID_OBJECTIVE = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.trigger.failed.invalid"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)Commands.literal("trigger").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("objective", ObjectiveArgument.objective()).suggests((p_139146_, p_139147_) -> TriggerCommand.suggestObjectives((CommandSourceStack)p_139146_.getSource(), p_139147_)).executes(p_139165_ -> TriggerCommand.simpleTrigger((CommandSourceStack)p_139165_.getSource(), TriggerCommand.getScore(((CommandSourceStack)p_139165_.getSource()).getPlayerOrException(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)p_139165_, "objective"))))).then(Commands.literal("add").then(Commands.argument("value", IntegerArgumentType.integer()).executes(p_139159_ -> TriggerCommand.addValue((CommandSourceStack)p_139159_.getSource(), TriggerCommand.getScore(((CommandSourceStack)p_139159_.getSource()).getPlayerOrException(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)p_139159_, "objective")), IntegerArgumentType.getInteger((CommandContext)p_139159_, (String)"value")))))).then(Commands.literal("set").then(Commands.argument("value", IntegerArgumentType.integer()).executes(p_139144_ -> TriggerCommand.setValue((CommandSourceStack)p_139144_.getSource(), TriggerCommand.getScore(((CommandSourceStack)p_139144_.getSource()).getPlayerOrException(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)p_139144_, "objective")), IntegerArgumentType.getInteger((CommandContext)p_139144_, (String)"value")))))));
    }

    public static CompletableFuture<Suggestions> suggestObjectives(CommandSourceStack pSource, SuggestionsBuilder pBuilder) {
        Entity entity = pSource.getEntity();
        ArrayList list = Lists.newArrayList();
        if (entity != null) {
            ServerScoreboard scoreboard = pSource.getServer().getScoreboard();
            String s = entity.getScoreboardName();
            for (Objective objective : scoreboard.getObjectives()) {
                Score score;
                if (objective.getCriteria() != ObjectiveCriteria.TRIGGER || !scoreboard.hasPlayerScore(s, objective) || (score = scoreboard.getOrCreatePlayerScore(s, objective)).isLocked()) continue;
                list.add(objective.getName());
            }
        }
        return SharedSuggestionProvider.suggest(list, pBuilder);
    }

    private static int addValue(CommandSourceStack pSource, Score pObjective, int pAmount) {
        pObjective.add(pAmount);
        pSource.sendSuccess(new TranslatableComponent("commands.trigger.add.success", pObjective.getObjective().getFormattedDisplayName(), pAmount), true);
        return pObjective.getScore();
    }

    private static int setValue(CommandSourceStack pSource, Score pObjective, int pValue) {
        pObjective.setScore(pValue);
        pSource.sendSuccess(new TranslatableComponent("commands.trigger.set.success", pObjective.getObjective().getFormattedDisplayName(), pValue), true);
        return pValue;
    }

    private static int simpleTrigger(CommandSourceStack pSource, Score pObjectives) {
        pObjectives.add(1);
        pSource.sendSuccess(new TranslatableComponent("commands.trigger.simple.success", pObjectives.getObjective().getFormattedDisplayName()), true);
        return pObjectives.getScore();
    }

    private static Score getScore(ServerPlayer pPlayer, Objective pObjective) throws CommandSyntaxException {
        String s;
        if (pObjective.getCriteria() != ObjectiveCriteria.TRIGGER) {
            throw ERROR_INVALID_OBJECTIVE.create();
        }
        Scoreboard scoreboard = pPlayer.getScoreboard();
        if (!scoreboard.hasPlayerScore(s = pPlayer.getScoreboardName(), pObjective)) {
            throw ERROR_NOT_PRIMED.create();
        }
        Score score = scoreboard.getOrCreatePlayerScore(s, pObjective);
        if (score.isLocked()) {
            throw ERROR_NOT_PRIMED.create();
        }
        score.setLocked(true);
        return score;
    }
}

