/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.TranslatableComponent;

public class WeatherCommand {
    private static final int DEFAULT_TIME = 6000;

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("weather").requires(p_139171_ -> p_139171_.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal("clear").executes(p_139190_ -> WeatherCommand.setClear((CommandSourceStack)p_139190_.getSource(), 6000))).then(Commands.argument("duration", IntegerArgumentType.integer((int)0, (int)1000000)).executes(p_139188_ -> WeatherCommand.setClear((CommandSourceStack)p_139188_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_139188_, (String)"duration") * 20))))).then(((LiteralArgumentBuilder)Commands.literal("rain").executes(p_139186_ -> WeatherCommand.setRain((CommandSourceStack)p_139186_.getSource(), 6000))).then(Commands.argument("duration", IntegerArgumentType.integer((int)0, (int)1000000)).executes(p_139181_ -> WeatherCommand.setRain((CommandSourceStack)p_139181_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_139181_, (String)"duration") * 20))))).then(((LiteralArgumentBuilder)Commands.literal("thunder").executes(p_139176_ -> WeatherCommand.setThunder((CommandSourceStack)p_139176_.getSource(), 6000))).then(Commands.argument("duration", IntegerArgumentType.integer((int)0, (int)1000000)).executes(p_139169_ -> WeatherCommand.setThunder((CommandSourceStack)p_139169_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_139169_, (String)"duration") * 20)))));
    }

    private static int setClear(CommandSourceStack pSource, int pTime) {
        pSource.getLevel().setWeatherParameters(pTime, 0, false, false);
        pSource.sendSuccess(new TranslatableComponent("commands.weather.set.clear"), true);
        return pTime;
    }

    private static int setRain(CommandSourceStack pSource, int pTime) {
        pSource.getLevel().setWeatherParameters(0, pTime, true, false);
        pSource.sendSuccess(new TranslatableComponent("commands.weather.set.rain"), true);
        return pTime;
    }

    private static int setThunder(CommandSourceStack pSource, int pTime) {
        pSource.getLevel().setWeatherParameters(0, pTime, true, true);
        pSource.sendSuccess(new TranslatableComponent("commands.weather.set.thunder"), true);
        return pTime;
    }
}

