/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;

public class WhitelistCommand {
    private static final SimpleCommandExceptionType ERROR_ALREADY_ENABLED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.whitelist.alreadyOn"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_DISABLED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.whitelist.alreadyOff"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_WHITELISTED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.whitelist.add.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_WHITELISTED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.whitelist.remove.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("whitelist").requires(p_139234_ -> p_139234_.hasPermission(3))).then(Commands.literal("on").executes(p_139236_ -> WhitelistCommand.enableWhitelist((CommandSourceStack)p_139236_.getSource())))).then(Commands.literal("off").executes(p_139232_ -> WhitelistCommand.disableWhitelist((CommandSourceStack)p_139232_.getSource())))).then(Commands.literal("list").executes(p_139228_ -> WhitelistCommand.showList((CommandSourceStack)p_139228_.getSource())))).then(Commands.literal("add").then(Commands.argument("targets", GameProfileArgument.gameProfile()).suggests((p_139216_, p_139217_) -> {
            PlayerList playerlist = ((CommandSourceStack)p_139216_.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerlist.getPlayers().stream().filter(p_142794_ -> !playerlist.getWhiteList().isWhiteListed(p_142794_.getGameProfile())).map(p_142791_ -> p_142791_.getGameProfile().getName()), p_139217_);
        }).executes(p_139224_ -> WhitelistCommand.addPlayers((CommandSourceStack)p_139224_.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)p_139224_, "targets")))))).then(Commands.literal("remove").then(Commands.argument("targets", GameProfileArgument.gameProfile()).suggests((p_139206_, p_139207_) -> SharedSuggestionProvider.a(((CommandSourceStack)p_139206_.getSource()).getServer().getPlayerList().getWhiteListNames(), p_139207_)).executes(p_139214_ -> WhitelistCommand.removePlayers((CommandSourceStack)p_139214_.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)p_139214_, "targets")))))).then(Commands.literal("reload").executes(p_139204_ -> WhitelistCommand.reload((CommandSourceStack)p_139204_.getSource()))));
    }

    private static int reload(CommandSourceStack pSource) {
        pSource.getServer().getPlayerList().reloadWhiteList();
        pSource.sendSuccess(new TranslatableComponent("commands.whitelist.reloaded"), true);
        pSource.getServer().kickUnlistedPlayers(pSource);
        return 1;
    }

    private static int addPlayers(CommandSourceStack pSource, Collection<GameProfile> pPlayers) throws CommandSyntaxException {
        UserWhiteList userwhitelist = pSource.getServer().getPlayerList().getWhiteList();
        int i = 0;
        for (GameProfile gameprofile : pPlayers) {
            if (userwhitelist.isWhiteListed(gameprofile)) continue;
            UserWhiteListEntry userwhitelistentry = new UserWhiteListEntry(gameprofile);
            userwhitelist.add(userwhitelistentry);
            pSource.sendSuccess(new TranslatableComponent("commands.whitelist.add.success", ComponentUtils.getDisplayName(gameprofile)), true);
            ++i;
        }
        if (i == 0) {
            throw ERROR_ALREADY_WHITELISTED.create();
        }
        return i;
    }

    private static int removePlayers(CommandSourceStack pSource, Collection<GameProfile> pPlayers) throws CommandSyntaxException {
        UserWhiteList userwhitelist = pSource.getServer().getPlayerList().getWhiteList();
        int i = 0;
        for (GameProfile gameprofile : pPlayers) {
            if (!userwhitelist.isWhiteListed(gameprofile)) continue;
            UserWhiteListEntry userwhitelistentry = new UserWhiteListEntry(gameprofile);
            userwhitelist.remove(userwhitelistentry);
            pSource.sendSuccess(new TranslatableComponent("commands.whitelist.remove.success", ComponentUtils.getDisplayName(gameprofile)), true);
            ++i;
        }
        if (i == 0) {
            throw ERROR_NOT_WHITELISTED.create();
        }
        pSource.getServer().kickUnlistedPlayers(pSource);
        return i;
    }

    private static int enableWhitelist(CommandSourceStack pSource) throws CommandSyntaxException {
        PlayerList playerlist = pSource.getServer().getPlayerList();
        if (playerlist.isUsingWhitelist()) {
            throw ERROR_ALREADY_ENABLED.create();
        }
        playerlist.setUsingWhiteList(true);
        pSource.sendSuccess(new TranslatableComponent("commands.whitelist.enabled"), true);
        pSource.getServer().kickUnlistedPlayers(pSource);
        return 1;
    }

    private static int disableWhitelist(CommandSourceStack pSource) throws CommandSyntaxException {
        PlayerList playerlist = pSource.getServer().getPlayerList();
        if (!playerlist.isUsingWhitelist()) {
            throw ERROR_ALREADY_DISABLED.create();
        }
        playerlist.setUsingWhiteList(false);
        pSource.sendSuccess(new TranslatableComponent("commands.whitelist.disabled"), true);
        return 1;
    }

    private static int showList(CommandSourceStack pSource) {
        CharSequence[] astring = pSource.getServer().getPlayerList().getWhiteListNames();
        if (astring.length == 0) {
            pSource.sendSuccess(new TranslatableComponent("commands.whitelist.none"), false);
        } else {
            pSource.sendSuccess(new TranslatableComponent("commands.whitelist.list", astring.length, String.join((CharSequence)", ", astring)), false);
        }
        return astring.length;
    }
}

