/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec2;

public class WorldBorderCommand {
    private static final SimpleCommandExceptionType ERROR_SAME_CENTER = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.worldborder.center.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_SIZE = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.worldborder.set.failed.nochange"));
    private static final SimpleCommandExceptionType ERROR_TOO_SMALL = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.worldborder.set.failed.small"));
    private static final SimpleCommandExceptionType ERROR_TOO_BIG = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.worldborder.set.failed.big", 5.9999968E7));
    private static final SimpleCommandExceptionType ERROR_TOO_FAR_OUT = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.worldborder.set.failed.far", 2.9999984E7));
    private static final SimpleCommandExceptionType ERROR_SAME_WARNING_TIME = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.worldborder.warning.time.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_WARNING_DISTANCE = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.worldborder.warning.distance.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_DAMAGE_BUFFER = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.worldborder.damage.buffer.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_DAMAGE_AMOUNT = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.worldborder.damage.amount.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("worldborder").requires(p_139268_ -> p_139268_.hasPermission(2))).then(Commands.literal("add").then(((RequiredArgumentBuilder)Commands.argument("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(p_139290_ -> WorldBorderCommand.setSize((CommandSourceStack)p_139290_.getSource(), ((CommandSourceStack)p_139290_.getSource()).getLevel().getWorldBorder().getSize() + DoubleArgumentType.getDouble((CommandContext)p_139290_, (String)"distance"), 0L))).then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(p_139288_ -> WorldBorderCommand.setSize((CommandSourceStack)p_139288_.getSource(), ((CommandSourceStack)p_139288_.getSource()).getLevel().getWorldBorder().getSize() + DoubleArgumentType.getDouble((CommandContext)p_139288_, (String)"distance"), ((CommandSourceStack)p_139288_.getSource()).getLevel().getWorldBorder().getLerpRemainingTime() + (long)IntegerArgumentType.getInteger((CommandContext)p_139288_, (String)"time") * 1000L)))))).then(Commands.literal("set").then(((RequiredArgumentBuilder)Commands.argument("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(p_139286_ -> WorldBorderCommand.setSize((CommandSourceStack)p_139286_.getSource(), DoubleArgumentType.getDouble((CommandContext)p_139286_, (String)"distance"), 0L))).then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(p_139284_ -> WorldBorderCommand.setSize((CommandSourceStack)p_139284_.getSource(), DoubleArgumentType.getDouble((CommandContext)p_139284_, (String)"distance"), (long)IntegerArgumentType.getInteger((CommandContext)p_139284_, (String)"time") * 1000L)))))).then(Commands.literal("center").then(Commands.argument("pos", Vec2Argument.vec2()).executes(p_139282_ -> WorldBorderCommand.setCenter((CommandSourceStack)p_139282_.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)p_139282_, "pos")))))).then(((LiteralArgumentBuilder)Commands.literal("damage").then(Commands.literal("amount").then(Commands.argument("damagePerBlock", FloatArgumentType.floatArg((float)0.0f)).executes(p_139280_ -> WorldBorderCommand.setDamageAmount((CommandSourceStack)p_139280_.getSource(), FloatArgumentType.getFloat((CommandContext)p_139280_, (String)"damagePerBlock")))))).then(Commands.literal("buffer").then(Commands.argument("distance", FloatArgumentType.floatArg((float)0.0f)).executes(p_139278_ -> WorldBorderCommand.setDamageBuffer((CommandSourceStack)p_139278_.getSource(), FloatArgumentType.getFloat((CommandContext)p_139278_, (String)"distance"))))))).then(Commands.literal("get").executes(p_139276_ -> WorldBorderCommand.getSize((CommandSourceStack)p_139276_.getSource())))).then(((LiteralArgumentBuilder)Commands.literal("warning").then(Commands.literal("distance").then(Commands.argument("distance", IntegerArgumentType.integer((int)0)).executes(p_139266_ -> WorldBorderCommand.setWarningDistance((CommandSourceStack)p_139266_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_139266_, (String)"distance")))))).then(Commands.literal("time").then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(p_139249_ -> WorldBorderCommand.setWarningTime((CommandSourceStack)p_139249_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_139249_, (String)"time")))))));
    }

    private static int setDamageBuffer(CommandSourceStack pSource, float pDistance) throws CommandSyntaxException {
        WorldBorder worldborder = pSource.getServer().overworld().getWorldBorder();
        if (worldborder.getDamageSafeZone() == (double)pDistance) {
            throw ERROR_SAME_DAMAGE_BUFFER.create();
        }
        worldborder.setDamageSafeZone(pDistance);
        pSource.sendSuccess(new TranslatableComponent("commands.worldborder.damage.buffer.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(pDistance))), true);
        return (int)pDistance;
    }

    private static int setDamageAmount(CommandSourceStack pSource, float pDamagePerBlock) throws CommandSyntaxException {
        WorldBorder worldborder = pSource.getServer().overworld().getWorldBorder();
        if (worldborder.getDamagePerBlock() == (double)pDamagePerBlock) {
            throw ERROR_SAME_DAMAGE_AMOUNT.create();
        }
        worldborder.setDamagePerBlock(pDamagePerBlock);
        pSource.sendSuccess(new TranslatableComponent("commands.worldborder.damage.amount.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(pDamagePerBlock))), true);
        return (int)pDamagePerBlock;
    }

    private static int setWarningTime(CommandSourceStack pSource, int pTime) throws CommandSyntaxException {
        WorldBorder worldborder = pSource.getServer().overworld().getWorldBorder();
        if (worldborder.getWarningTime() == pTime) {
            throw ERROR_SAME_WARNING_TIME.create();
        }
        worldborder.setWarningTime(pTime);
        pSource.sendSuccess(new TranslatableComponent("commands.worldborder.warning.time.success", pTime), true);
        return pTime;
    }

    private static int setWarningDistance(CommandSourceStack pSource, int pDistance) throws CommandSyntaxException {
        WorldBorder worldborder = pSource.getServer().overworld().getWorldBorder();
        if (worldborder.getWarningBlocks() == pDistance) {
            throw ERROR_SAME_WARNING_DISTANCE.create();
        }
        worldborder.setWarningBlocks(pDistance);
        pSource.sendSuccess(new TranslatableComponent("commands.worldborder.warning.distance.success", pDistance), true);
        return pDistance;
    }

    private static int getSize(CommandSourceStack pSource) {
        double d0 = pSource.getServer().overworld().getWorldBorder().getSize();
        pSource.sendSuccess(new TranslatableComponent("commands.worldborder.get", String.format(Locale.ROOT, "%.0f", d0)), false);
        return Mth.floor(d0 + 0.5);
    }

    private static int setCenter(CommandSourceStack pSource, Vec2 pPos) throws CommandSyntaxException {
        WorldBorder worldborder = pSource.getServer().overworld().getWorldBorder();
        if (worldborder.getCenterX() == (double)pPos.x && worldborder.getCenterZ() == (double)pPos.y) {
            throw ERROR_SAME_CENTER.create();
        }
        if (!((double)Math.abs(pPos.x) > 2.9999984E7) && !((double)Math.abs(pPos.y) > 2.9999984E7)) {
            worldborder.setCenter(pPos.x, pPos.y);
            pSource.sendSuccess(new TranslatableComponent("commands.worldborder.center.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(pPos.x)), String.format("%.2f", Float.valueOf(pPos.y))), true);
            return 0;
        }
        throw ERROR_TOO_FAR_OUT.create();
    }

    private static int setSize(CommandSourceStack pSource, double pNewSize, long p_139255_) throws CommandSyntaxException {
        WorldBorder worldborder = pSource.getServer().overworld().getWorldBorder();
        double d0 = worldborder.getSize();
        if (d0 == pNewSize) {
            throw ERROR_SAME_SIZE.create();
        }
        if (pNewSize < 1.0) {
            throw ERROR_TOO_SMALL.create();
        }
        if (pNewSize > 5.9999968E7) {
            throw ERROR_TOO_BIG.create();
        }
        if (p_139255_ > 0L) {
            worldborder.lerpSizeBetween(d0, pNewSize, p_139255_);
            if (pNewSize > d0) {
                pSource.sendSuccess(new TranslatableComponent("commands.worldborder.set.grow", String.format(Locale.ROOT, "%.1f", pNewSize), Long.toString(p_139255_ / 1000L)), true);
            } else {
                pSource.sendSuccess(new TranslatableComponent("commands.worldborder.set.shrink", String.format(Locale.ROOT, "%.1f", pNewSize), Long.toString(p_139255_ / 1000L)), true);
            }
        } else {
            worldborder.setSize(pNewSize);
            pSource.sendSuccess(new TranslatableComponent("commands.worldborder.set.immediate", String.format(Locale.ROOT, "%.1f", pNewSize)), true);
        }
        return (int)(pNewSize - d0);
    }
}

